/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync.SynchronizationTestFixture;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.utils.JaxWsUtils;

public class SeiSyncronizationTest
extends SynchronizationTestFixture {
    public void test_changedSeiNameSynched() throws Exception {
        this.target.startSynchronizing();
        ICompilationUnit sei1CU = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(sei1CU, "@javax.jws.WebService() public interface Sei1 {}");
        JobUtils.waitForJobs();
        SeiSyncronizationTest.assertEquals((String)"Sei1", (String)this.sei1.getName());
        this.testUtil.setContents(sei1CU, "@javax.jws.WebService(name=\"Sei1NewName\") public interface Sei1 {}");
        JobUtils.waitForJobs();
        SeiSyncronizationTest.assertEquals((String)"Sei1NewName", (String)this.sei1.getName());
        SeiSyncronizationTest.assertTrue((boolean)this.sei1.getImplementingWebServices().contains((Object)this.ws1));
        SeiSyncronizationTest.assertSame((Object)this.sei1, (Object)this.domUtil.findSeiByImplName(this.wsPrj1, this.sei1.getImplementation()));
    }

    public void test_changedSeiTargetNamespaceSynched() throws Exception {
        this.target.startSynchronizing();
        SeiSyncronizationTest.assertEquals((String)JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"com.sap.test.modelsync1"), (String)this.sei1.getTargetNamespace());
        ICompilationUnit sei1CU = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(sei1CU, "@javax.jws.WebService(name=\"Sei1NewName\", targetNamespace=\"http://com.sap/test\") public interface Sei1 {}");
        JobUtils.waitForJobs();
        SeiSyncronizationTest.assertEquals((String)"Sei1NewName", (String)this.sei1.getName());
        SeiSyncronizationTest.assertTrue((boolean)this.sei1.getImplementingWebServices().contains((Object)this.ws1));
        SeiSyncronizationTest.assertSame((Object)this.sei1, (Object)this.domUtil.findSeiByImplName(this.wsPrj1, this.sei1.getImplementation()));
        SeiSyncronizationTest.assertEquals((String)"SEI targetNamespace not synched", (String)"http://com.sap/test", (String)this.sei1.getTargetNamespace());
    }

    public void test_SoapBindingStyleChanged() throws Exception {
        this.target.startSynchronizing();
        SeiSyncronizationTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)this.sei1.getSoapBindingStyle());
        SeiSyncronizationTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)this.sei1.getSoapBindingUse());
        SeiSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)this.sei1.getSoapBindingParameterStyle());
        ICompilationUnit sei1CU = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(sei1CU, "@javax.jws.soap.SOAPBinding(style=Style.RPC, use=Use.ENCODED, parameterStyle=ParameterStyle.BARE)@javax.jws.WebService() public interface Sei1 {}");
        JobUtils.waitForJobs();
        SeiSyncronizationTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)this.sei1.getSoapBindingStyle());
        SeiSyncronizationTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)this.sei1.getSoapBindingUse());
        SeiSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)this.sei1.getSoapBindingParameterStyle());
    }
}

