/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.requests;

import java.util.Map;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NodeCreationFactory
implements CreationFactory {
    private final String _tagName;
    private final String _uri;
    private final String _suggestedPrefix;
    private final Map _attributes;

    public NodeCreationFactory(String uri, String tagname, String suggestedPrefix, Map attributes) {
        this._tagName = tagname;
        this._uri = uri;
        this._suggestedPrefix = suggestedPrefix;
        this._attributes = attributes;
    }

    public Object getNewObject() {
        String prefix;
        Document ownerdoc = this.getOwnerDocument();
        if (ownerdoc == null) {
            return null;
        }
        Element ele = ownerdoc.createElement(this._tagName);
        if (ele instanceof IDOMNode && (prefix = this.getPrefix(this._uri, ((IDOMDocument)ownerdoc).getModel(), this._suggestedPrefix)) != null) {
            ele.setPrefix(prefix);
        }
        if (this._attributes != null) {
            for (String key : this._attributes.keySet()) {
                String value = (String)this._attributes.get(key);
                ele.setAttribute(key, value);
            }
        }
        return ele;
    }

    public Object getObjectType() {
        return this._tagName;
    }

    protected Document getOwnerDocument() {
        IWorkbenchWindow active = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (active == null) {
            return null;
        }
        IWorkbenchPage page = active.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof HTMLEditor) {
            return ((HTMLEditor)editor).getDOMDocument();
        }
        return null;
    }

    private String getPrefix(String uri, IDOMModel model, String suggested) {
        if ("html".equals(uri) || "jsp".equals(uri)) {
            return null;
        }
        return JSPUtil.getOrCreatePrefix(model, uri, suggested);
    }
}

