/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.el.DefaultDTVariableResolver;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.osgi.framework.Bundle;

public class TestDefaultDTVariableResolver
extends TestCase {
    private IType _testBean1Type;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private JDTTestEnvironment _jdtTestEnvironment;
    private IFile _testJSP1;
    private static final String SRC_FOLDER_NAME = "src";
    private static final String PACKAGE_NAME = "com.test";
    private static final String TESTBEAN1_NAME = "TestBean1";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestDefaultPropertyResolver_" + this.getName());
        projectTestEnvironment.createProject(false);
        IResource res = projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP1 = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
        IProject project = projectTestEnvironment.getTestProject();
        FacesConfigArtifactEdit edit = null;
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, null);
            FacesConfigType model = edit.getFacesConfig();
            ManagedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            beanClass.setTextContent("com.test.TestBean1");
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent("testBean1");
            ManagedBeanScopeType beanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            beanScope.setTextContent("session");
            ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
            bean.setManagedBeanClass(beanClass);
            bean.setManagedBeanName(beanName);
            bean.setManagedBeanScope(beanScope);
            model.getManagedBean().add((Object)bean);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        this._jdtTestEnvironment.addResourceFile(SRC_FOLDER_NAME, (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/TestBean1.java.data", (String)TESTBEAN1_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestDefaultDTVariableResolver.assertNotNull((Object)this._testBean1Type);
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider(null);
    }

    public void testResolveVariable() {
        this.checkBuiltinVariables();
        this.checkSymbolMaps();
        this.checkManagedBeanVariable();
    }

    private void checkBuiltinVariables() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        DefaultDTVariableResolver variableResolver = new DefaultDTVariableResolver();
        ISymbol symbol = variableResolver.resolveVariable(manager.getFacesContext(this._testJSP1), "applicationScope", (IAdaptable)this._testJSP1);
        TestDefaultDTVariableResolver.assertNotNull((Object)symbol);
    }

    private void checkSymbolMaps() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        DefaultDTVariableResolver variableResolver = new DefaultDTVariableResolver();
        ISymbol symbol = variableResolver.resolveVariable(manager.getFacesContext(this._testJSP1), "bundle", (IAdaptable)this._testJSP1);
        TestDefaultDTVariableResolver.assertNotNull((Object)symbol);
        TestDefaultDTVariableResolver.assertTrue((boolean)(symbol instanceof IComponentSymbol));
        IComponentSymbol compSymbol = (IComponentSymbol)symbol;
        TestDefaultDTVariableResolver.assertEquals((String)"bundle", (String)compSymbol.getName());
        ITypeDescriptor typeDesc = compSymbol.getTypeDescriptor();
        TestDefaultDTVariableResolver.assertTrue((boolean)(typeDesc instanceof IMapTypeDescriptor));
    }

    private void checkManagedBeanVariable() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        DefaultDTVariableResolver variableResolver = new DefaultDTVariableResolver();
        ISymbol symbol = variableResolver.resolveVariable(manager.getFacesContext(this._testJSP1), "testBean1", (IAdaptable)this._testJSP1);
        TestDefaultDTVariableResolver.assertNotNull((Object)symbol);
        TestDefaultDTVariableResolver.assertTrue((boolean)(symbol instanceof IBeanInstanceSymbol));
        IBeanInstanceSymbol compSymbol = (IBeanInstanceSymbol)symbol;
        TestDefaultDTVariableResolver.assertEquals((String)"testBean1", (String)compSymbol.getName());
        ITypeDescriptor typeDesc = compSymbol.getTypeDescriptor();
        TestDefaultDTVariableResolver.assertTrue((boolean)(typeDesc instanceof IJavaTypeDescriptor2));
        TestDefaultDTVariableResolver.assertEquals((String)"Lcom.test.TestBean1;", (String)typeDesc.getTypeSignature());
    }

    public void testGetAllVariables() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        DefaultDTVariableResolver variableResolver = new DefaultDTVariableResolver();
        ISymbol[] variables = variableResolver.getAllVariables(manager.getFacesContext(this._testJSP1), (IAdaptable)this._testJSP1);
        this.assertContainsVariable(variables, "applicationScope");
        this.assertContainsVariable(variables, "sessionScope");
        this.assertContainsVariable(variables, "requestScope");
        this.assertContainsVariable(variables, "cookie");
        this.assertContainsVariable(variables, "facesContext");
        this.assertContainsVariable(variables, "header");
        this.assertContainsVariable(variables, "headerValues");
        this.assertContainsVariable(variables, "initParam");
        this.assertContainsVariable(variables, "param");
        this.assertContainsVariable(variables, "paramValues");
        this.assertContainsVariable(variables, "view");
        this.assertContainsVariable(variables, "testBean1");
        this.assertContainsVariable(variables, "bundle");
        this.assertDoesNotContainVariable(variables, "viewScope");
        this.assertDoesNotContainVariable(variables, "flash");
        this.assertDoesNotContainVariable(variables, "cc");
        this.assertDoesNotContainVariable(variables, "component");
        this.assertDoesNotContainVariable(variables, "resource");
    }

    private void assertContainsVariable(ISymbol[] variables, String name) {
        ISymbol[] iSymbolArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol variable = iSymbolArray[n2];
            if (name.equals(variable.getName())) {
                TestDefaultDTVariableResolver.assertTrue((boolean)(variable instanceof IInstanceSymbol));
                return;
            }
            ++n2;
        }
        TestDefaultDTVariableResolver.fail((String)("Expected variable not found: " + name));
    }

    private void assertDoesNotContainVariable(ISymbol[] variables, String name) {
        ISymbol[] iSymbolArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol variable = iSymbolArray[n2];
            if (name.equals(variable.getName())) {
                TestDefaultDTVariableResolver.fail((String)("Variable was not expected to be found: " + name));
                return;
            }
            ++n2;
        }
    }
}

