/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.container;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.range.RangeUtil;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.ui.actions.ActionGroup;
import org.w3c.dom.Text;

public class ContainerActionGroup
extends ActionGroup {
    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        EditPart part = this.findCommonAncesterPart(selection);
        if (!(part instanceof NodeEditPart)) {
            return;
        }
        NodeEditPart original = (NodeEditPart)part;
        while (part.getParent() instanceof ElementEditPart) {
            boolean filled;
            ElementEditPart elementEditPart = (ElementEditPart)part.getParent();
            IElementEdit elementEdit = elementEditPart.getElementEdit();
            if (elementEdit != null && (filled = elementEdit.fillContainerContextMenu(menu, elementEditPart, original, selection))) break;
            part = part.getParent();
        }
    }

    private EditPart findCommonAncesterPart(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structsel = (IStructuredSelection)selection;
            if (structsel.size() != 1) {
                return null;
            }
            if (structsel.getFirstElement() instanceof EditPart) {
                return (EditPart)structsel.getFirstElement();
            }
            return null;
        }
        if (selection instanceof DesignRange) {
            DesignRange range = (DesignRange)selection;
            if (!range.isValid()) {
                return null;
            }
            if (range.isEmpty()) {
                DesignPosition position = range.getStartPosition();
                if (position.getOffset() == 0 || position.getContainerNode() instanceof Text) {
                    return position.getContainerPart();
                }
                return position.getSiblingEditPart(false);
            }
            return RangeUtil.findCommonAncestor(range);
        }
        return null;
    }
}

