/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitHandler;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public abstract class CompilationUnitFinderContractTest
extends MockObjectTestCase {
    private List<IProjectSelector> projectSelectors;
    private IJavaModel javaModel;
    private List<String> existingProjectsNames;

    protected IJavaModel javaModel() {
        return this.javaModel;
    }

    protected List<IProjectSelector> projectSelectors() {
        return this.projectSelectors;
    }

    protected abstract ICompilationUnitFinder createTarget();

    public void setUp() {
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.projectSelectors = new ArrayList<IProjectSelector>();
        this.existingProjectsNames = new ArrayList<String>();
        IProject[] iProjectArray = this.javaModel.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            this.existingProjectsNames.add(prj.getName());
            ++n2;
        }
    }

    public void test_find() throws CoreException, WsDOMLoadCanceledException {
        final TestProject project1 = new TestProject();
        project1.createSourceFolder("sourceFolder");
        final IPackageFragment pf1 = project1.createPackage("com.sap.test1");
        project1.createType(pf1, "CompilationUnit1.java", "class Ignorred{}");
        project1.createType(pf1, "CompilationUnit2.java", "class Ignorred{}");
        project1.createType(pf1, "CompilationUnit3.java", "class Ignorred{}");
        final TestProject project2 = new TestProject();
        project2.createSourceFolder("sourceFolder");
        IPackageFragment pf2 = project2.createPackage("com.sap.test1");
        project2.createType(pf2, "CompilationUnit1.java", "class Ignorred{}");
        project2.createType(pf2, "CompilationUnit2.java", "class Ignorred{}");
        final TestProject project3 = new TestProject();
        project3.createSourceFolder("sourceFolder");
        final IPackageFragment pf3 = project3.createPackage("com.sap.test3");
        project3.createType(pf3, "CompilationUnit1.java", "class Ignorred{}");
        project3.createType(pf3, "CompilationUnit2.java", "class Ignorred{}");
        IProjectSelector exludeProject2 = new IProjectSelector(){

            public boolean approve(IJavaProject prj) {
                return !prj.getElementName().equals(project2.getJavaProject().getElementName()) && !CompilationUnitFinderContractTest.this.existingProjectsNames.contains(prj.getElementName());
            }
        };
        IProjectSelector addmitAll_exceptProject2 = new IProjectSelector(){

            public boolean approve(IJavaProject prj) {
                return !prj.getElementName().equals(project2.getJavaProject().getElementName()) && !CompilationUnitFinderContractTest.this.existingProjectsNames.contains(prj.getElementName());
            }
        };
        this.projectSelectors().add(exludeProject2);
        this.projectSelectors().add(addmitAll_exceptProject2);
        ICompilationUnitFinder target = this.createTarget();
        final Mock mockCUHandler = this.mock(ICompilationUnitHandler.class);
        Stub configureExpectations = new Stub(){

            public Object invoke(Invocation arg0) throws Throwable {
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.projectNamed(project1.getJavaProject().getElementName())).id("cuCall1");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.cuNamed(pf1.getCompilationUnit("CompilationUnit1.java").getPath().toOSString())).after("cuCall1").id("cuCall2");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.cuNamed(pf1.getCompilationUnit("CompilationUnit2.java").getPath().toOSString())).after("cuCall1").id("cuCall3");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.cuNamed(pf1.getCompilationUnit("CompilationUnit3.java").getPath().toOSString())).after("cuCall1").id("cuCall4");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.projectNamed(project3.getJavaProject().getElementName())).id("cuCall5");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.cuNamed(pf3.getCompilationUnit("CompilationUnit1.java").getPath().toOSString())).after("cuCall5").id("cuCall6");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("handle").with(CompilationUnitFinderContractTest.this.cuNamed(pf3.getCompilationUnit("CompilationUnit2.java").getPath().toOSString())).after("cuCall5").id("cuCall7");
                mockCUHandler.expects(CompilationUnitFinderContractTest.this.once()).method("finished").withNoArguments().after("cuCall1").after("cuCall2").after("cuCall3").after("cuCall4").after("cuCall5").after("cuCall6").after("cuCall7");
                return null;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0.append("Configure expectations after start is invoked");
            }
        };
        mockCUHandler.expects(this.once()).method("started").withNoArguments().will(configureExpectations);
        target.find(null, (ICompilationUnitHandler)mockCUHandler.proxy());
    }

    private Constraint projectNamed(final String prjName) {
        return new Constraint(){

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0.append(prjName);
            }

            public boolean eval(Object arg0) {
                if (!(arg0 instanceof IJavaProject)) {
                    return false;
                }
                IJavaProject cast = (IJavaProject)arg0;
                return prjName.equals(cast.getElementName());
            }
        };
    }

    private Constraint cuNamed(final String cuName) {
        return new Constraint(){

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0.append(cuName);
            }

            public boolean eval(Object arg0) {
                if (!(arg0 instanceof ICompilationUnit)) {
                    return false;
                }
                ICompilationUnit cast = (ICompilationUnit)arg0;
                return cuName.equals(cast.getPath().toOSString());
            }
        };
    }
}

