/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.WebServiceRef;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;

public class AddMemberValuePairToAnnotationTest
extends AbstractAnnotationTest {
    @Override
    protected Annotation getAnnotation() {
        return null;
    }

    @Override
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n");
        classContents.append("import javax.jws.WebMethod;\n");
        classContents.append("import javax.jws.WebParam;\n");
        classContents.append("import javax.xml.ws.WebServiceRef;\n\n");
        classContents.append("@WebService()\n");
        classContents.append("public class Calculator {\n\n");
        classContents.append("\t@WebServiceRef()\n");
        classContents.append("\tpublic String myField;\n\n");
        classContents.append("\t@WebMethod()\n");
        classContents.append("\tpublic int add(@WebParam() int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    @Override
    protected String getClassName() {
        return "Calculator.java";
    }

    @Override
    protected String getPackageName() {
        return "com.example";
    }

    public void testAddMemberValuePairToAnnotation() {
        try {
            IType type = this.source.findPrimaryType();
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)"WebService"));
            Annotation webService = AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
            AddMemberValuePairToAnnotationTest.assertNotNull((Object)webService);
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)(webService instanceof NormalAnnotation));
            NormalAnnotation webServiceAnnotation = (NormalAnnotation)webService;
            AddMemberValuePairToAnnotationTest.assertTrue((webServiceAnnotation.values().size() == 0 ? 1 : 0) != 0);
            MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (String)"Calculator");
            AnnotationUtils.addMemberValuePair((NormalAnnotation)webServiceAnnotation, (MemberValuePair)nameValuePair);
            webServiceAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
            AddMemberValuePairToAnnotationTest.assertTrue((webServiceAnnotation.values().size() == 1 ? 1 : 0) != 0);
            IField field = type.getField("myField");
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)field, (String)"WebServiceRef"));
            Annotation webServiceRef = AnnotationUtils.getAnnotation((IJavaElement)field, WebServiceRef.class);
            AddMemberValuePairToAnnotationTest.assertNotNull((Object)webServiceRef);
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)(webServiceRef instanceof NormalAnnotation));
            NormalAnnotation webServiceRefAnnotation = (NormalAnnotation)webServiceRef;
            AddMemberValuePairToAnnotationTest.assertTrue((webServiceRefAnnotation.values().size() == 0 ? 1 : 0) != 0);
            MemberValuePair mappedNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"mappedName", (String)"myField");
            AnnotationUtils.addMemberValuePair((NormalAnnotation)webServiceRefAnnotation, (MemberValuePair)mappedNameValuePair);
            webServiceRefAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)field, WebServiceRef.class);
            AddMemberValuePairToAnnotationTest.assertTrue((webServiceRefAnnotation.values().size() == 1 ? 1 : 0) != 0);
            IMethod method = type.getMethod("add", new String[]{"I", "I"});
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)"WebMethod"));
            Annotation webMethod = AnnotationUtils.getAnnotation((IJavaElement)method, WebMethod.class);
            AddMemberValuePairToAnnotationTest.assertNotNull((Object)webMethod);
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)(webMethod instanceof NormalAnnotation));
            NormalAnnotation webMethodAnnotation = (NormalAnnotation)webMethod;
            AddMemberValuePairToAnnotationTest.assertTrue((webMethodAnnotation.values().size() == 0 ? 1 : 0) != 0);
            MemberValuePair operationNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"operationName", (String)"add");
            AnnotationUtils.addMemberValuePair((NormalAnnotation)webMethodAnnotation, (MemberValuePair)operationNameValuePair);
            webMethodAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)method, WebMethod.class);
            AddMemberValuePairToAnnotationTest.assertTrue((webMethodAnnotation.values().size() == 1 ? 1 : 0) != 0);
            ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)method, (String)"i");
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)localVariable, (String)"WebParam"));
            Annotation webParam = AnnotationUtils.getAnnotation((IJavaElement)localVariable, WebParam.class);
            AddMemberValuePairToAnnotationTest.assertNotNull((Object)webParam);
            AddMemberValuePairToAnnotationTest.assertTrue((boolean)(webParam instanceof NormalAnnotation));
            NormalAnnotation webParamAnnotation = (NormalAnnotation)webParam;
            AddMemberValuePairToAnnotationTest.assertTrue((webParamAnnotation.values().size() == 0 ? 1 : 0) != 0);
            MemberValuePair partNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"partName", (String)"i");
            AnnotationUtils.addMemberValuePair((NormalAnnotation)webParamAnnotation, (MemberValuePair)partNameValuePair);
            webParamAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)localVariable, WebParam.class);
            AddMemberValuePairToAnnotationTest.assertTrue((webParamAnnotation.values().size() == 1 ? 1 : 0) != 0);
        }
        catch (CoreException ce) {
            AddMemberValuePairToAnnotationTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

