/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.Classpath;
import org.eclipse.jpt.common.utility.internal.SystemTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

public class ClasspathTests
extends TestCase {
    private static final String JAVA_HOME = System.getProperty("java.home");

    public ClasspathTests(String name) {
        super(name);
    }

    public void testCompressed() {
        String path = "";
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;;;;C:\\jdk\\jaws.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;;;")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\..\\jdk\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk1\\jdk2\\jdk3\\..\\..\\..\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().getPath();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
    }

    public void testConvertToClassName() {
        String fileName = "java/lang/String.class";
        File file = new File(fileName);
        String className = Classpath.convertToClassName((File)file);
        ClasspathTests.assertEquals((String)String.class.getName(), (String)className);
    }

    public void testConvertToClass() throws ClassNotFoundException {
        String fileName = "java/lang/String.class";
        File file = new File(fileName);
        Class javaClass = Classpath.convertToClass((File)file);
        ClasspathTests.assertEquals(String.class, (Object)javaClass);
    }

    public void testConvertToArchiveClassFileEntryName() {
        String fileName = Classpath.convertToArchiveClassFileEntryName(String.class);
        ClasspathTests.assertEquals((String)"java/lang/String.class", (String)fileName);
    }

    public void testConvertToArchiveEntryNameBase() {
        String fileName = Classpath.convertToArchiveEntryNameBase(String.class);
        ClasspathTests.assertEquals((String)"java/lang/String", (String)fileName);
    }

    public void testConvertToClassFileName() {
        char sc = File.separatorChar;
        String fileName = Classpath.convertToClassFileName(String.class);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.class"), (String)fileName);
    }

    public void testConvertToClassFileString() {
        char sc = File.separatorChar;
        File file = Classpath.convertToClassFile((String)String.class.getName());
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.class"), (String)file.getPath());
    }

    public void testConvertToClassFileClass() {
        char sc = File.separatorChar;
        File file = Classpath.convertToClassFile(String.class);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.class"), (String)file.getPath());
    }

    public void testConvertToJavaFileName() {
        char sc = File.separatorChar;
        String fileName = Classpath.convertToJavaFileName(String.class);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.java"), (String)fileName);
    }

    public void testConvertToJavaFileString() {
        char sc = File.separatorChar;
        File file = Classpath.convertToJavaFile((String)String.class.getName());
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.java"), (String)file.getPath());
    }

    public void testConvertToJavaFileClass() {
        char sc = File.separatorChar;
        File file = Classpath.convertToJavaFile(String.class);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.java"), (String)file.getPath());
    }

    public void testConvertToFileNameBase() {
        char sc = File.separatorChar;
        String fileName = Classpath.convertToFileNameBase(String.class);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String"), (String)fileName);
    }

    public void testConvertToURLs() {
        Iterator entries = new Classpath(this.morph("C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getURLs().iterator();
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/rt.jar"), (String)((URL)entries.next()).getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/i18n.jar"), (String)((URL)entries.next()).getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/jaws.jar"), (String)((URL)entries.next()).getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/foo/classes"), (String)((URL)entries.next()).getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/bar/bar.jar"), (String)((URL)entries.next()).getPath());
        ClasspathTests.assertFalse((boolean)entries.hasNext());
    }

    public void testGetEntries() {
        Classpath cp = new Classpath(this.morph("C:\\jdk\\rt.jar;;.;C:\\jdk\\i18n.jar;;;C:\\jdk\\jaws.jar;;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\bar\\bar.jar;"));
        Iterator entries = cp.getEntries().iterator();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("."), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\jaws.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\foo\\classes"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertFalse((boolean)entries.hasNext());
        cp = cp.compressed();
        entries = cp.getEntries().iterator();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("."), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\jaws.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\foo\\classes"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)((Classpath.Entry)entries.next()).getFileName());
        ClasspathTests.assertFalse((boolean)entries.hasNext());
    }

    public void testGetEntryForFileNamed() {
        Classpath.Entry entry = null;
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;rt.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.getFileName());
        entry = new Classpath(this.morph("C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath(this.morph("rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.getFileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rt.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;rt.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.getFileName());
        entry = new Classpath(this.morph("C:\\jdk\\rt.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath("rt.jar").getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.getFileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rtrtrt.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.getFileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rtrtrt.jar")).getEntryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"path entry should not be found", null, (Object)entry);
    }

    public void testGetEntryForClassNamed() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            ClasspathTests.assertNotNull((Object)Classpath.completeClasspath().getEntryForClassNamed(String.class.getName()));
            ClasspathTests.assertNull((Object)Classpath.completeClasspath().getEntryForClassNamed("foo.bar.Baz"));
        }
    }

    public void testLocationForClass() {
        Class<Classpath> javaClass = Classpath.class;
        File entry = new File(Classpath.locationFor(javaClass));
        if (entry.isFile() || entry.isDirectory()) {
            ClasspathTests.assertTrue((boolean)entry.exists());
        }
        if (entry.isDirectory()) {
            ClasspathTests.assertTrue((boolean)new File(entry, Classpath.convertToClassFileName(javaClass)).exists());
        }
    }

    public void testRtJarName() throws IOException {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            File rtFile = new File(Classpath.rtJarName());
            ClasspathTests.assertTrue((String)"rt.jar does not exist", (boolean)rtFile.exists());
            JarFile rtJarFile = new JarFile(rtFile);
            JarEntry entry = rtJarFile.getJarEntry("java/lang/Object.class");
            rtJarFile.close();
            ClasspathTests.assertTrue((String)"bogus rt.jar", (entry != null ? 1 : 0) != 0);
        }
    }

    public void testJREClassNames() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            ClasspathTests.assertTrue((String)"Vector is missing from JRE class names", (boolean)IterableTools.contains((Iterable)Classpath.bootClasspath().getClassNames(), (Object)Vector.class.getName()));
            ClasspathTests.assertTrue((String)"File is missing from JRE class names", (boolean)IterableTools.contains((Iterable)Classpath.bootClasspath().getClassNames(), (Object)File.class.getName()));
        }
    }

    public void testJavaExtensionDirectoryNames() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            char sep = File.separatorChar;
            String stdExtDirName = String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext";
            ClasspathTests.assertTrue((String)("standard extension dir name missing: " + stdExtDirName), (boolean)ArrayTools.contains((Object[])Classpath.javaExtensionDirectoryNames(), (Object)stdExtDirName));
        }
    }

    public void testJavaExtensionDirectories() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            char sep = File.separatorChar;
            File stdExtDir = new File(String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext");
            ClasspathTests.assertTrue((String)("standard extension dir missing: " + stdExtDir.getParent()), (boolean)ArrayTools.contains((Object[])Classpath.javaExtensionDirectories(), (Object)stdExtDir));
        }
    }

    public void testJavaExtensionClasspathEntries() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"1.4") || SystemTools.javaSpecificationVersionIsGreaterThan((String)"11")) {
            ClasspathTests.fail((String)("we need to update this test for the current JDK: " + SystemTools.javaSpecificationVersion()));
        }
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            ArrayList<String> jarNames = new ArrayList<String>();
            Iterable entries = Classpath.javaExtensionClasspath().getEntries();
            for (Classpath.Entry entry : entries) {
                jarNames.add(entry.getFileName());
            }
            char sep = File.separatorChar;
            String stdExtJarName = String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext" + sep + "dnsns.jar";
            String msg = "JDK standard extension jar missing: " + stdExtJarName;
            boolean jarPresent = jarNames.contains(stdExtJarName);
            if (SystemTools.jvmIsSun() || SystemTools.jvmIsIBM() && SystemTools.javaSpecificationVersionIsGreaterThan((String)"1.5")) {
                ClasspathTests.assertTrue((String)msg, (boolean)jarPresent);
            }
        }
    }

    public void testJavaExtensionClassNames() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"1.4") || SystemTools.javaSpecificationVersionIsGreaterThan((String)"11")) {
            ClasspathTests.fail((String)("we need to update this test for the current JDK: " + SystemTools.javaSpecificationVersion()));
        }
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            String className = "sun.net.spi.nameservice.dns.DNSNameService";
            String msg = "JDK standard extension class missing: " + className;
            boolean classPresent = IteratorTools.contains((Iterator)Classpath.javaExtensionClasspath().classNames(), (Object)className);
            if (SystemTools.jvmIsSun() || SystemTools.jvmIsIBM() && SystemTools.javaSpecificationVersionIsGreaterThan((String)"1.5")) {
                ClasspathTests.assertTrue((String)msg, (boolean)classPresent);
            }
        }
    }

    public void testJavaClasspathClassNames() {
        String className = ((Object)((Object)this)).getClass().getName();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl.getClass().getName().startsWith("sun.misc")) {
            ClasspathTests.assertTrue((String)("class missing: " + className), (boolean)IterableTools.contains((Iterable)Classpath.javaClasspath().getClassNames(), (Object)className));
        }
    }

    public void testCompleteClasspathClassNames() {
        String className = ((Object)((Object)this)).getClass().getName();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl.getClass().getName().startsWith("sun.misc")) {
            ClasspathTests.assertTrue((String)("class missing: " + className), (boolean)IterableTools.contains((Iterable)Classpath.completeClasspath().getClassNames(), (Object)className));
        }
    }

    public void testClasspathForClass() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            ClasspathTests.assertNotNull((Object)Classpath.classpathFor(String.class));
        }
    }

    public void testAddClassNamesTo() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            ArrayList classNames = new ArrayList(1000);
            Classpath.bootClasspath().addClassNamesTo(classNames);
            ClasspathTests.assertTrue((boolean)classNames.contains(Vector.class.getName()));
        }
    }

    public void testToString() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            ClasspathTests.assertNotNull((Object)Classpath.bootClasspath().toString());
        }
    }

    public void testEntry_getCanonicalFile() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            ClasspathTests.assertTrue((boolean)entry.getCanonicalFile().getPath().endsWith(".jar"));
        }
    }

    public void testEntry_getCanonicalFileName() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            String name = entry.getCanonicalFileName();
            if (SystemTools.jvmIsSun()) {
                ClasspathTests.assertTrue((boolean)name.endsWith("rt.jar"));
            } else if (SystemTools.jvmIsIBM()) {
                ClasspathTests.assertTrue((boolean)name.endsWith("vm.jar"));
            }
        }
    }

    public void testEntry_equals() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            ClasspathTests.assertFalse((boolean)entry.equals((Object)"foo"));
        }
    }

    public void testEntry_containsClass() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            ClasspathTests.assertTrue((boolean)entry.contains(String.class));
        }
    }

    public void testEntry_containsString() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            ClasspathTests.assertTrue((boolean)entry.contains(String.class.getName()));
        }
    }

    public void testEntry_getClassNames() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            ClasspathTests.assertTrue((boolean)IterableTools.contains((Iterable)entry.getClassNames(), (Object)String.class.getName()));
        }
    }

    public void testEntry_classNames() {
        if (SystemTools.javaSpecificationVersionIsLessThan((String)"11")) {
            Classpath.Entry entry = Classpath.bootClasspath().getEntryForClassNamed(String.class.getName());
            ClasspathTests.assertTrue((boolean)IteratorTools.contains((Iterator)entry.classNames(), (Object)String.class.getName()));
        }
    }

    private String morph(String path) {
        String result = path;
        result = result.replace('\\', File.separatorChar);
        result = result.replace(';', File.pathSeparatorChar);
        if (!ArrayTools.contains((Object[])File.listRoots(), (Object)new File("C:\\"))) {
            result = result.replaceAll("C:", "");
        }
        return result;
    }

    private String morphURL(String url) {
        String result = url;
        if (!ArrayTools.contains((Object[])File.listRoots(), (Object)new File("C:\\"))) {
            result = result.replaceAll("/C:", "");
        }
        return result;
    }
}

