/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IPredefinedSourceWrapProvider;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.ui.PluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.TableUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.LaunchTabGroup;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.TabBase;

public class ScriptMappingTab
extends TabBase<Elements, LaunchTabGroup.Params> {
    static final TabBase.TabFieldList<Elements, LaunchTabGroup.Params> TAB_FIELDS;

    static {
        ArrayList<TabBase.TabField<String, Object, Elements, LaunchTabGroup.Params>> list = new ArrayList<TabBase.TabField<String, Object, Elements, LaunchTabGroup.Params>>(4);
        list.add(new TabBase.TabField<String, LaunchParams.LookupMode, Elements, LaunchTabGroup.Params>("source_lookup_mode", TabBase.TypedMethods.STRING, new TabBase.FieldAccess<LaunchParams.LookupMode, Elements>(){

            @Override
            void setValue(LaunchParams.LookupMode value, Elements tabElements) {
                tabElements.getLookupMode().select(value);
            }

            @Override
            LaunchParams.LookupMode getValue(Elements tabElements) {
                return tabElements.getLookupMode().getSelected();
            }
        }, new TabBase.DefaultsProvider<LaunchParams.LookupMode, LaunchTabGroup.Params>(){

            @Override
            LaunchParams.LookupMode getFallbackValue() {
                return LaunchParams.LookupMode.DEFAULT_VALUE;
            }

            @Override
            LaunchParams.LookupMode getInitialConfigValue(LaunchTabGroup.Params context) {
                return LaunchParams.LookupMode.AUTO_DETECT;
            }
        }, LaunchParams.LookupMode.STRING_CONVERTER));
        list.add(new TabBase.TabField<String, List<String>, Elements, LaunchTabGroup.Params>(LaunchParams.PredefinedSourceWrapperIds.CONFIG_PROPERTY, TabBase.TypedMethods.STRING, new TabBase.FieldAccess<List<String>, Elements>(){

            @Override
            void setValue(List<String> value, Elements tabElements) {
                tabElements.getPredefinedWrapChooser().setData(value, IPredefinedSourceWrapProvider.Access.getEntries());
            }

            @Override
            List<String> getValue(Elements tabElements) {
                ArrayList<String> result = new ArrayList<String>(tabElements.getPredefinedWrapChooser().getValue());
                return result;
            }
        }, new TabBase.DefaultsProvider<List<String>, LaunchTabGroup.Params>(){

            @Override
            List<String> getFallbackValue() {
                return Collections.emptyList();
            }

            @Override
            List<String> getInitialConfigValue(LaunchTabGroup.Params context) {
                List<String> result = context.preEnableSourceWrapper() ? new ArrayList(IPredefinedSourceWrapProvider.Access.getEntries().keySet()) : Collections.emptyList();
                return result;
            }
        }, LaunchParams.PredefinedSourceWrapperIds.CONVERTER));
        TAB_FIELDS = ScriptMappingTab.createFieldListImpl(list);
    }

    ScriptMappingTab(LaunchTabGroup.Params params) {
        super(params);
    }

    @Override
    public Elements createElements(Composite parent, final Runnable modifyListener) {
        Composite composite = ScriptMappingTab.createDefaultComposite(parent);
        this.setControl((Control)composite);
        LookupModeControl lookupModeControl = new LookupModeControl(composite, ((LaunchTabGroup.Params)this.getParams()).getScriptNameDescription());
        TabBase.RadioButtonsLogic.Listener radioButtonsListener = new TabBase.RadioButtonsLogic.Listener(){

            @Override
            public void selectionChanged() {
                modifyListener.run();
            }
        };
        final TabBase.RadioButtonsLogic<LaunchParams.LookupMode> lookupModeLogic = lookupModeControl.createLogic(radioButtonsListener);
        Group group = new Group(composite, 0);
        group.setText(Messages.ScriptMappingTab_RECOGNIZED_WRAPPING);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        final PredefinedWrapChooser wrapChooser = new PredefinedWrapChooser((Composite)group);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        wrapChooser.getControl().setLayoutData((Object)data2);
        wrapChooser.addListener(new PredefinedWrapChooser.Listener(){

            @Override
            public void checkStateChanged() {
                modifyListener.run();
            }
        });
        return new Elements(){

            @Override
            public TabBase.RadioButtonsLogic<LaunchParams.LookupMode> getLookupMode() {
                return lookupModeLogic;
            }

            @Override
            public PredefinedWrapChooser getPredefinedWrapChooser() {
                return wrapChooser;
            }
        };
    }

    public String getName() {
        return Messages.ScriptMappingTab_TAB_NAME;
    }

    @Override
    protected TabBase.MessageData isValidImpl(ILaunchConfiguration config) {
        try {
            LaunchParams.PredefinedSourceWrapperIds.resolveEntries((ILaunchConfiguration)config);
        }
        catch (CoreException e) {
            return new TabBase.MessageData(false, NLS.bind((String)Messages.ScriptMappingTab_UNRESOLVED_ERROR_MESSAGE, (Object)e.getMessage()));
        }
        return null;
    }

    @Override
    protected TabBase.TabFieldList<Elements, LaunchTabGroup.Params> getTabFields() {
        return TAB_FIELDS;
    }

    static interface Elements {
        public TabBase.RadioButtonsLogic<LaunchParams.LookupMode> getLookupMode();

        public PredefinedWrapChooser getPredefinedWrapChooser();
    }

    private static class LookupModeControl {
        private final Map<LaunchParams.LookupMode, Button> buttons = new LinkedHashMap<LaunchParams.LookupMode, Button>();

        LookupModeControl(Composite container, String scriptNameFormatDescription) {
            Group group = new Group(container, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setText(Messages.ChromiumRemoteTab_LOOKUP_GROUP_TITLE);
            group.setLayout((Layout)new GridLayout(1, false));
            this.buttons.put(LaunchParams.LookupMode.EXACT_MATCH, LookupModeControl.createButtonBlock((Composite)group, Messages.ChromiumRemoteTab_EXACT_MATCH, Messages.ChromiumRemoteTab_EXACT_MATCH_LINE1, Messages.ChromiumRemoteTab_EXACT_MATCH_LINE2));
            this.buttons.put(LaunchParams.LookupMode.AUTO_DETECT, LookupModeControl.createButtonBlock((Composite)group, Messages.ChromiumRemoteTab_AUTODETECT, Messages.ChromiumRemoteTab_AUTODETECT_LINE1, String.valueOf(Messages.ChromiumRemoteTab_AUTODETECT_LINE2) + scriptNameFormatDescription));
            ScriptMappingTab.addRadioButtonSwitcher(this.buttons.values());
        }

        TabBase.RadioButtonsLogic<LaunchParams.LookupMode> createLogic(TabBase.RadioButtonsLogic.Listener listener) {
            return new TabBase.RadioButtonsLogic<LaunchParams.LookupMode>(this.buttons, listener);
        }

        private static Button createButtonBlock(Composite parent, String buttonLabel, String descriptionLine1, String descriptionLine2) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout gridLayout = ScriptMappingTab.createHtmlStyleGridLayout(3);
            buttonComposite.setLayout((Layout)gridLayout);
            Button button = new Button(buttonComposite, 0x400010);
            button.setText(buttonLabel);
            Label padding = new Label(buttonComposite, 0);
            padding.setText("   ");
            Label descriptionLine1Label = new Label(buttonComposite, 0);
            descriptionLine1Label.setText(descriptionLine1);
            new Label(buttonComposite, 0);
            new Label(buttonComposite, 0);
            Label descriptionLine2Label = new Label(buttonComposite, 0);
            descriptionLine2Label.setText(descriptionLine2);
            return button;
        }
    }

    private static class PredefinedWrapChooser {
        private final Control root;
        private final CheckboxTableViewer tableViewer;
        private final List<Listener> listeners = new ArrayList<Listener>(1);

        PredefinedWrapChooser(Composite parent) {
            Table table = new Table(parent, 68130);
            this.root = table;
            table.setFont(parent.getFont());
            this.tableViewer = new CheckboxTableViewer(table);
            table.setHeaderVisible(false);
            this.tableViewer.setContentProvider((IContentProvider)TableUtils.OBJECT_ARRAY_CONTENT_PROVIDER);
            TableUtils.ColumnLabelProvider<ItemData> columnOneLabelProvider = new TableUtils.ColumnLabelProvider<ItemData>(){
                private final ItemData.Visitor<String> columnTextVisitor = new ItemData.Visitor<String>(){

                    @Override
                    public String visitNormal(IPredefinedSourceWrapProvider.Entry entry) {
                        return entry.getWrapper().getName();
                    }

                    @Override
                    public String visitUnresolved(String id) {
                        return NLS.bind((String)Messages.ScriptMappingTab_UNRESOVLED, (Object)id);
                    }
                };

                @Override
                public Image getColumnImage(ItemData element) {
                    return null;
                }

                @Override
                public String getColumnText(ItemData element) {
                    return element.accept(this.columnTextVisitor);
                }

                @Override
                public TableColumn createColumn(Table table) {
                    TableColumn statusCol = new TableColumn(table, 0);
                    int width = PluginUtil.getFontMetrics((Drawable)table, table.getFont()).getAverageCharWidth() * 40;
                    statusCol.setWidth(width);
                    return statusCol;
                }
            };
            ArrayList columnList = new ArrayList(1);
            columnList.add(TableUtils.ColumnData.create(new TableUtils.TrivialAdapter(), columnOneLabelProvider));
            TableUtils.ColumnBasedLabelProvider<ItemData> labelProvider = new TableUtils.ColumnBasedLabelProvider<ItemData>(TableUtils.createCastAdapter(ItemData.class), columnList);
            labelProvider.setUpColumns(table);
            this.tableViewer.setLabelProvider(labelProvider);
            this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(final DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection.size() != 1) {
                        return;
                    }
                    ItemData data = (ItemData)structuredSelection.getFirstElement();
                    data.accept(new ItemData.Visitor<Void>(){

                        @Override
                        public Void visitNormal(IPredefinedSourceWrapProvider.Entry entry) {
                            MessageBox messageBox = new MessageBox(event.getViewer().getControl().getShell(), 16);
                            String description = entry.getHumanDescription();
                            messageBox.setText(Messages.ScriptMappingTab_DESCRIPTION);
                            messageBox.setMessage(description);
                            messageBox.open();
                            return null;
                        }

                        @Override
                        public Void visitUnresolved(String id) {
                            return null;
                        }
                    });
                }
            });
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    for (Listener listener : listeners) {
                        listener.checkStateChanged();
                    }
                }
            });
        }

        Control getControl() {
            return this.root;
        }

        void setData(Collection<String> wrapperIds, Map<String, IPredefinedSourceWrapProvider.Entry> entriesMap) {
            ArrayList<ItemData> itemList = new ArrayList<ItemData>(entriesMap.size());
            HashMap<String, Integer> idToPosition = new HashMap<String, Integer>(entriesMap.size());
            for (Map.Entry<String, IPredefinedSourceWrapProvider.Entry> en : entriesMap.entrySet()) {
                idToPosition.put(en.getKey(), itemList.size());
                itemList.add(ItemData.createNormal(en.getValue()));
            }
            ArrayList<ItemData> selected = new ArrayList<ItemData>(wrapperIds.size());
            for (String id : wrapperIds) {
                ItemData item;
                Integer pos = (Integer)idToPosition.get(id);
                if (pos == null) {
                    item = ItemData.createUnresolved(id);
                    itemList.add(item);
                } else {
                    item = (ItemData)itemList.get(pos);
                }
                selected.add(item);
            }
            this.tableViewer.setInput((Object)itemList.toArray());
            this.tableViewer.setCheckedElements(selected.toArray());
        }

        Collection<String> getValue() {
            Object[] selection = this.tableViewer.getCheckedElements();
            ArrayList<String> result = new ArrayList<String>(selection.length);
            ItemData.Visitor<String> visitor = new ItemData.Visitor<String>(){

                @Override
                public String visitNormal(IPredefinedSourceWrapProvider.Entry entry) {
                    return entry.getId();
                }

                @Override
                public String visitUnresolved(String id) {
                    return id;
                }
            };
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectionObject = objectArray[n2];
                ItemData item = (ItemData)selectionObject;
                result.add(item.accept(visitor));
                ++n2;
            }
            return result;
        }

        void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        static abstract class ItemData {
            ItemData() {
            }

            abstract <R> R accept(Visitor<R> var1);

            static ItemData createNormal(final IPredefinedSourceWrapProvider.Entry entry) {
                return new ItemData(){

                    @Override
                    <R> R accept(Visitor<R> visitor) {
                        return visitor.visitNormal(entry);
                    }
                };
            }

            static ItemData createUnresolved(final String id) {
                return new ItemData(){

                    @Override
                    <R> R accept(Visitor<R> visitor) {
                        return visitor.visitUnresolved(id);
                    }
                };
            }

            static interface Visitor<R> {
                public R visitNormal(IPredefinedSourceWrapProvider.Entry var1);

                public R visitUnresolved(String var1);
            }
        }

        static interface Listener {
            public void checkStateChanged();
        }
    }
}

