/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.source.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.source.SourceNameMapperContainerDialogLogic;

public class SourceNameMapperContainerDialog
extends TitleAreaDialog {
    private final ISourceLookupDirector director;
    private final PresetFieldValues initialParams;
    private Result result = null;
    private SourceNameMapperContainerDialogLogic logic = null;
    private static final Comparator<ISourceContainerType> TYPE_COMPARATOR_BY_NAME = new Comparator<ISourceContainerType>(){

        @Override
        public int compare(ISourceContainerType o1, ISourceContainerType o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public Result getResult() {
        return this.result;
    }

    public SourceNameMapperContainerDialog(Shell shell, ISourceLookupDirector director, PresetFieldValues initialParams) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.director = director;
        this.initialParams = initialParams;
    }

    protected Control createDialogArea(Composite ancestor) {
        this.getShell().setText(Messages.SourceNameMapperContainerDialog_DIALOG_TITLE);
        this.setTitle(Messages.SourceNameMapperContainerDialog_DIALOG_SUBTITLE);
        Composite parent = new Composite(ancestor, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)new GridData(1808));
        Label explanationOne = new Label(parent, 0);
        explanationOne.setText(Messages.SourceNameMapperContainerDialog_EXPLANATION_1);
        Group prefixGroup = new Group(parent, 0);
        prefixGroup.setLayoutData((Object)new GridData(768));
        prefixGroup.setText(Messages.SourceNameMapperContainerDialog_PREFIX_GROUP);
        prefixGroup.setLayout((Layout)new GridLayout(1, false));
        final Text prefixEditor = new Text((Composite)prefixGroup, 2052);
        prefixEditor.setLayoutData((Object)new GridData(768));
        final Label prefixExampleLine1Label = new Label((Composite)prefixGroup, 0);
        prefixExampleLine1Label.setLayoutData((Object)new GridData(768));
        final Label prefixExampleLine2Label = new Label((Composite)prefixGroup, 0);
        prefixExampleLine2Label.setLayoutData((Object)new GridData(768));
        Label explanationTwo = new Label(parent, 0);
        explanationTwo.setText(Messages.SourceNameMapperContainerDialog_EXPLANATION_2);
        Group containerGroup = new Group(parent, 0);
        containerGroup.setLayout((Layout)new GridLayout(1, false));
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setText(Messages.SourceNameMapperContainerDialog_CONTAINER_GROUP);
        Composite typeBlock = new Composite((Composite)containerGroup, 0);
        typeBlock.setLayout((Layout)new GridLayout(3, false));
        typeBlock.setLayoutData((Object)new GridData(768));
        final List<ISourceContainerType> types = this.filterTypes(DebugPlugin.getDefault().getLaunchManager().getSourceContainerTypes());
        Collections.sort(types, TYPE_COMPARATOR_BY_NAME);
        String[] typeNameArray = new String[types.size()];
        int i = 0;
        while (i < typeNameArray.length) {
            typeNameArray[i] = types.get(i).getName();
            ++i;
        }
        Label comboLabel = new Label(typeBlock, 0);
        comboLabel.setText(Messages.SourceNameMapperContainerDialog_TYPE_LABEL);
        Combo typesCombo = new Combo(typeBlock, 8);
        typesCombo.setLayoutData((Object)new GridData(768));
        typesCombo.setFont(parent.getFont());
        typesCombo.setItems(typeNameArray);
        if (typeNameArray.length > 0) {
            typesCombo.select(0);
        }
        final Button configureButton = new Button(typeBlock, 8);
        configureButton.setText(Messages.SourceNameMapperContainerDialog_CONFIGURE_BUTTON);
        final Composite statusBox = new Composite((Composite)containerGroup, 0);
        statusBox.setLayout((Layout)new GridLayout(3, false));
        statusBox.setLayoutData((Object)new GridData(768));
        final Label statusLabel = new Label(statusBox, 0);
        final Label containerTypeIconLabel = new Label(statusBox, 0);
        final Label containerNameLabel = new Label(statusBox, 0);
        Dialog.applyDialogFont((Control)parent);
        final DialogUtils.ComboWrapper<ISourceContainerType> comboWrapper = new DialogUtils.ComboWrapper<ISourceContainerType>(typesCombo){

            @Override
            public ISourceContainerType getSelected() {
                return (ISourceContainerType)types.get(this.getCombo().getSelectionIndex());
            }

            @Override
            public void setSelected(ISourceContainerType element) {
                int index = types.indexOf(element);
                if (index != -1) {
                    this.getCombo().select(index);
                }
            }
        };
        final ContainerStatusGroup containerStatusGroup = new ContainerStatusGroup(){

            @Override
            public Label getStatusLabel() {
                return statusLabel;
            }

            @Override
            public Label getTypeImageLabel() {
                return containerTypeIconLabel;
            }

            @Override
            public Label getContainerNameLabel() {
                return containerNameLabel;
            }

            @Override
            public void layout() {
                statusBox.layout();
            }

            @Override
            public void setEnabled(boolean enabled) {
                statusLabel.setEnabled(enabled);
                containerTypeIconLabel.setEnabled(enabled);
                containerNameLabel.setEnabled(enabled);
            }
        };
        Elements elements = new Elements(){

            @Override
            public Text getPrefixField() {
                return prefixEditor;
            }

            @Override
            public Label getPrefixExampleLine1Label() {
                return prefixExampleLine1Label;
            }

            @Override
            public Label getPrefixExampleLine2Label() {
                return prefixExampleLine2Label;
            }

            @Override
            public Button getConfigureButton() {
                return configureButton;
            }

            @Override
            public DialogUtils.ComboWrapper<ISourceContainerType> getContainerTypeCombo() {
                return comboWrapper;
            }

            @Override
            public Shell getShell() {
                return SourceNameMapperContainerDialog.this.getShell();
            }

            @Override
            public ContainerStatusGroup getContainerStatusGroup() {
                return containerStatusGroup;
            }

            @Override
            public Button getOkButton() {
                return SourceNameMapperContainerDialog.this.getButton(0);
            }

            @Override
            public void setMessage(String message, int type) {
                SourceNameMapperContainerDialog.this.setMessage(message, type);
            }
        };
        this.logic = SourceNameMapperContainerDialogLogic.create(elements, this.director, this.initialParams);
        return parent;
    }

    public void create() {
        super.create();
        this.logic.updateAll();
    }

    protected void okPressed() {
        this.result = this.logic.getResult();
        super.okPressed();
    }

    static ConfigureButtonAction prepareConfigureAction(ISourceContainerType type, ISourceContainer alreadyCreatedContainer, final ISourceLookupDirector director) {
        abstract class ActionBase
        implements ConfigureButtonAction {
            ActionBase() {
            }

            @Override
            public ISourceContainer run(Shell shell) {
                ISourceContainer[] containers = this.runImpl(shell);
                if (containers.length != 1) {
                    return null;
                }
                return containers[0];
            }

            abstract ISourceContainer[] runImpl(Shell var1);
        }
        ISourceContainer[] alreadyCreatedContainerArray;
        if (type == null) {
            return null;
        }
        final ISourceContainerBrowser browser = DebugUITools.getSourceContainerBrowser((String)type.getId());
        if (browser == null) {
            return null;
        }
        if (alreadyCreatedContainer != null && alreadyCreatedContainer.getType().equals(type) && browser.canEditSourceContainers(director, alreadyCreatedContainerArray = new ISourceContainer[]{alreadyCreatedContainer})) {
            return new ActionBase(){
                {
                }

                @Override
                ISourceContainer[] runImpl(Shell shell) {
                    return browser.editSourceContainers(shell, director, alreadyCreatedContainerArray);
                }
            };
        }
        if (browser.canAddSourceContainers(director)) {
            return new ActionBase(){
                {
                }

                @Override
                ISourceContainer[] runImpl(Shell shell) {
                    return browser.addSourceContainers(shell, director);
                }
            };
        }
        return null;
    }

    private List<ISourceContainerType> filterTypes(ISourceContainerType[] types) {
        ArrayList<ISourceContainerType> result = new ArrayList<ISourceContainerType>();
        int i = 0;
        while (i < types.length) {
            ISourceContainerBrowser sourceContainerBrowser;
            ISourceContainerType type = types[i];
            if (this.director.supportsSourceContainerType(type) && (sourceContainerBrowser = DebugUITools.getSourceContainerBrowser((String)type.getId())) != null && sourceContainerBrowser.canAddSourceContainers(this.director)) {
                result.add(type);
            }
            ++i;
        }
        return result;
    }

    static interface ConfigureButtonAction {
        public ISourceContainer run(Shell var1);
    }

    static interface ContainerStatusGroup {
        public Label getStatusLabel();

        public Label getTypeImageLabel();

        public Label getContainerNameLabel();

        public void layout();

        public void setEnabled(boolean var1);
    }

    static interface Elements
    extends DialogUtils.OkButtonElements {
        public Text getPrefixField();

        public Label getPrefixExampleLine1Label();

        public Label getPrefixExampleLine2Label();

        public DialogUtils.ComboWrapper<ISourceContainerType> getContainerTypeCombo();

        public Button getConfigureButton();

        public ContainerStatusGroup getContainerStatusGroup();

        public Shell getShell();
    }

    public static interface PresetFieldValues {
        public String getPrefix();

        public ISourceContainer getContainer();
    }

    public static interface Result {
        public String getResultPrefix();

        public ISourceContainer getResultContainer();
    }
}

