/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class UpdateTypeReferenceCommand
extends BaseCommand {
    XSDConcreteComponent concreteComponent;
    XSDTypeDefinition newType;

    public UpdateTypeReferenceCommand(XSDConcreteComponent concreteComponent, XSDTypeDefinition newType) {
        this.concreteComponent = concreteComponent;
        this.newType = newType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.concreteComponent.getElement());
            if (this.concreteComponent instanceof XSDElementDeclaration) {
                this.setElementType((XSDElementDeclaration)this.concreteComponent);
            } else if (this.concreteComponent instanceof XSDAttributeUse) {
                this.setAttributeType((XSDAttributeUse)this.concreteComponent);
            } else if (this.concreteComponent instanceof XSDAttributeDeclaration) {
                this.setAttributeType((XSDAttributeDeclaration)this.concreteComponent);
            }
            Object var1_3 = null;
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.endRecording();
            throw throwable;
        }
        this.endRecording();
    }

    protected void setElementType(XSDElementDeclaration ed) {
        if ((ed = ed.getResolvedElementDeclaration()) != null) {
            ed.setTypeDefinition(this.newType);
        }
    }

    protected void setAttributeType(XSDAttributeUse attributeUse) {
        this.setAttributeType(attributeUse.getAttributeDeclaration());
    }

    protected void setAttributeType(XSDAttributeDeclaration ad) {
        if ((ad = ad.getResolvedAttributeDeclaration()) != null && this.newType instanceof XSDSimpleTypeDefinition) {
            ad.setTypeDefinition((XSDSimpleTypeDefinition)this.newType);
        }
    }
}

