/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.wsdl.Definition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.StringTokenizer;

public class BP2201
extends AssertionProcess {
    private final WSDLValidatorImpl validator;
    private final char[] OMMITED_XML_DECLARATION_DELIMITERS = new char[]{' ', '\t', '\r', '\n', '\'', '\"'};
    private final char[] XML_DECLARATION_DELIMITERS = new char[]{'='};
    private final String UTF_8_ENCODING = "UTF-8";
    private final String UTF_16_ENCODING = "UTF-16";
    private final String ENCODING_TOKEN = "encoding";

    public BP2201(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        String location = definition.getDocumentBaseURI();
        String xmlDecl = this.readXMLDeclarationStatement(location);
        if (xmlDecl == null) {
            this.result = "notApplicable";
        } else if (!this.validEncoding(xmlDecl)) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(xmlDecl, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String readXMLDeclarationStatement(String location) {
        String result;
        block26: {
            result = null;
            if (location != null) {
                Reader reader;
                block23: {
                    StringBuffer buf;
                    block24: {
                        block25: {
                            URL url = null;
                            reader = null;
                            try {
                                url = new URL(location);
                            }
                            catch (MalformedURLException malformedURLException) {}
                            reader = url != null ? new InputStreamReader(url.openStream()) : new InputStreamReader(new FileInputStream(location));
                            boolean end = false;
                            if (!reader.ready()) break block23;
                            int charCode = reader.read();
                            while (reader.ready() && charCode != 60) {
                                charCode = reader.read();
                            }
                            char[] c = new char[4];
                            reader.read(c);
                            buf = new StringBuffer();
                            if (new String(c).toLowerCase().equals("?xml")) {
                                buf.append("<?xml");
                                while (reader.ready() && !end) {
                                    charCode = reader.read();
                                    buf.append((char)charCode);
                                    boolean bl = end = charCode == 62;
                                }
                                break block24;
                            }
                            this.result = "notApplicable";
                            if (reader == null) break block25;
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        return null;
                    }
                    try {
                        try {
                            result = buf.toString();
                        }
                        catch (Exception e) {
                            if (this.validator.verboseOption) {
                                System.err.println("  [WSI2201] Exception: " + e.getMessage());
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {}
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {}
                        }
                        throw throwable;
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return result;
    }

    private boolean validEncoding(String xmlDecl) {
        boolean result = true;
        if (xmlDecl != null) {
            StringTokenizer st = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration tokens = st.parse(xmlDecl);
            boolean found = false;
            while (tokens.hasMoreElements() && !found) {
                String token = (String)tokens.nextElement();
                if (!token.equals("encoding")) continue;
                found = true;
                tokens.nextElement();
                String enc = (String)tokens.nextElement();
                boolean bl = result = "UTF-8".equalsIgnoreCase(enc) || "UTF-16".equalsIgnoreCase(enc);
            }
        }
        return result;
    }
}

