/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ManyToOneAnnotation2_0;

public final class SourceManyToOneAnnotation
extends SourceRelationshipMappingAnnotation
implements ManyToOneAnnotation2_0 {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.ManyToOne");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceManyToOneAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceManyToOneAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceManyToOneAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceManyToOneAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    private Boolean optional;
    private TextRange optionalTextRange;

    public SourceManyToOneAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.ManyToOne";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.optional = this.buildOptional(astAnnotation);
        this.optionalTextRange = this.buildOptionalTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncOptional(this.buildOptional(astAnnotation));
        this.optionalTextRange = this.buildOptionalTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.optional == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (ObjectTools.notEquals((Object)this.optional, (Object)optional)) {
            this.optional = optional;
            this.optionalAdapter.setValue((Object)optional);
        }
    }

    private void syncOptional(Boolean astOptional) {
        Boolean old = this.optional;
        this.optional = astOptional;
        this.firePropertyChanged("optional", old, astOptional);
    }

    private Boolean buildOptional(Annotation astAnnotation) {
        return (Boolean)this.optionalAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getOptionalTextRange() {
        return this.optionalTextRange;
    }

    private TextRange buildOptionalTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceManyToOneAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceManyToOneAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return SourceManyToOneAnnotation.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceManyToOneAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }
}

