/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.consumption.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.messages.Axis2ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;

public class ContentCopyUtils {
    private List fileAndDirectoriesList = new ArrayList();
    private IEnvironment environment;
    FileInputStream finStream = null;

    public ContentCopyUtils(IEnvironment env) {
        this.environment = env;
    }

    public IStatus copyDirectoryRecursivelyIntoWorkspace(String sourceDir, String destinationDir, IProgressMonitor monitor, IStatusHandler statusHandler) {
        IStatus status = Status.OK_STATUS;
        this.fileAndDirectoriesList.clear();
        File axis2WebappFolder = new File(sourceDir);
        this.visitAllDirsAndFiles(axis2WebappFolder);
        List deployFiles = new ArrayList();
        deployFiles = this.fileAndDirectoriesList;
        try {
            ResourceContext context = this.environment == null ? WebServicePlugin.getInstance().getResourceContext() : ((BaseEclipseEnvironment)this.environment).getResourceContext();
            Path outputPath = new Path(destinationDir);
            IPath targetPath = null;
            boolean isDirectory = false;
            String tempOutputDir = axis2WebappFolder.toString();
            for (String deployFile : deployFiles) {
                File source = new File(deployFile);
                if (source.isDirectory()) {
                    isDirectory = true;
                } else {
                    isDirectory = false;
                    this.finStream = new FileInputStream(source);
                }
                if (!deployFile.startsWith(tempOutputDir)) continue;
                String fileName = deployFile.substring(tempOutputDir.length());
                targetPath = outputPath.append(fileName).makeAbsolute();
                if (isDirectory) {
                    FileResourceUtils.makeFolderPathAtLocation((ResourceContext)context, (IPath)targetPath, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                    continue;
                }
                if (this.finStream != null) {
                    FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)targetPath, (InputStream)this.finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                }
                this.finStream.close();
            }
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2ConsumptionUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2ConsumptionUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        return status;
    }

    private void visitAllDirsAndFiles(File dir) {
        this.fileAndDirectoriesList.add(dir.getAbsolutePath());
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                this.visitAllDirsAndFiles(new File(dir, children[i]));
                ++i;
            }
        }
    }
}

