/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderActionType;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryUninstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.jst.common.project.facet.core.libprov.internal.PropertiesHost;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.util.internal.CollectionsUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.MiscUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.ProgressMonitorUtil;

public final class LibraryInstallDelegate
extends PropertiesHost {
    private static final String CLASS_NAME = LibraryInstallDelegate.class.getName();
    public static final String PROP_AVAILABLE_PROVIDERS = String.valueOf(CLASS_NAME) + ".AVAILABLE_PROVIDERS";
    public static final String PROP_SELECTED_PROVIDER = String.valueOf(CLASS_NAME) + ".SELECTED_PROVIDER";
    private final IFacetedProjectBase fproj;
    private IProjectFacetVersion fv;
    private List<ILibraryProvider> providers;
    private List<ILibraryProvider> providersReadOnly;
    private ILibraryProvider selectedProvider;
    private boolean isDefaultSelection;
    private final Map<ILibraryProvider, LibraryProviderOperationConfig> configs;
    private final IPropertyChangeListener providerConfigListener;
    private LibraryUninstallDelegate uninstallDelegate = null;
    private Map<String, Object> customEnablementContextVariables;
    private final IFacetedProjectListener facetedProjectListener;

    public LibraryInstallDelegate(IFacetedProjectBase fproj, IProjectFacetVersion fv, Map<String, Object> customEnablementContextVariables) {
        this.fproj = fproj;
        this.fv = fv;
        this.providers = Collections.emptyList();
        this.providersReadOnly = Collections.emptyList();
        this.selectedProvider = null;
        this.isDefaultSelection = true;
        this.configs = new HashMap<ILibraryProvider, LibraryProviderOperationConfig>();
        this.customEnablementContextVariables = new HashMap<String, Object>();
        if (customEnablementContextVariables != null) {
            this.customEnablementContextVariables.putAll(customEnablementContextVariables);
        }
        this.providerConfigListener = new IPropertyChangeListener(){

            @Override
            public void propertyChanged(String property, Object oldValue, Object newValue) {
                LibraryInstallDelegate.this.notifyListeners(property, oldValue, newValue);
            }
        };
        this.facetedProjectListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                LibraryInstallDelegate.this.refresh();
            }
        };
        this.getFacetedProject().addListener(this.facetedProjectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
        this.reset();
    }

    public LibraryInstallDelegate(IFacetedProjectBase fproj, IProjectFacetVersion fv) {
        this(fproj, fv, null);
    }

    public IFacetedProjectBase getFacetedProject() {
        return this.fproj;
    }

    public synchronized IProjectFacet getProjectFacet() {
        return this.fv.getProjectFacet();
    }

    public synchronized IProjectFacetVersion getProjectFacetVersion() {
        return this.fv;
    }

    public synchronized void setProjectFacetVersion(IProjectFacetVersion fv) {
        this.fv = fv;
        this.refresh();
    }

    public synchronized List<ILibraryProvider> getLibraryProviders() {
        return this.providersReadOnly;
    }

    public synchronized ILibraryProvider getLibraryProvider() {
        return this.selectedProvider;
    }

    public synchronized void setLibraryProvider(ILibraryProvider provider) {
        this.setLibraryProvider(provider, false, true);
    }

    private synchronized void setLibraryProvider(ILibraryProvider provider, boolean isDefaultSelection, boolean notifyListeners) {
        if (!(this.providers.contains(provider) || this.providers.size() == 0 && provider == null)) {
            throw new IllegalArgumentException();
        }
        if (!MiscUtil.equal((Object)this.selectedProvider, (Object)provider)) {
            ILibraryProvider oldSelectedProvider = this.selectedProvider;
            this.selectedProvider = provider;
            this.isDefaultSelection = isDefaultSelection;
            LibraryProviderOperationConfig config = this.configs.get(this.selectedProvider);
            if (config != null) {
                config.reset();
            }
            if (notifyListeners) {
                this.notifyListeners(PROP_SELECTED_PROVIDER, oldSelectedProvider, this.selectedProvider);
            }
        }
    }

    public synchronized LibraryProviderOperationConfig getLibraryProviderOperationConfig() {
        if (this.selectedProvider == null) {
            return null;
        }
        return this.configs.get(this.selectedProvider);
    }

    public synchronized LibraryProviderOperationConfig getLibraryProviderOperationConfig(ILibraryProvider provider) {
        if (!this.providers.contains(provider)) {
            throw new IllegalArgumentException();
        }
        return this.configs.get(provider);
    }

    public synchronized void setEnablementContextVariable(String name, Object value) {
        Object currentValue = this.customEnablementContextVariables.get(name);
        if (!MiscUtil.equal((Object)currentValue, (Object)value)) {
            if (value == null) {
                this.customEnablementContextVariables.remove(name);
            } else {
                this.customEnablementContextVariables.put(name, value);
            }
            this.refresh();
        }
    }

    public synchronized void refresh() {
        IProjectFacet f = this.getProjectFacet();
        IProjectFacetVersion fv = this.getProjectFacetVersion();
        IFacetedProjectBase fproj = this.getFacetedProject();
        List<ILibraryProvider> oldProviders = this.providers;
        for (ILibraryProvider provider : oldProviders) {
            LibraryProviderOperationConfig config = this.configs.remove(provider);
            if (config == null) continue;
            config.removeListener(this.providerConfigListener);
            config.dispose();
        }
        ArrayList<ILibraryProvider> newProviders = new ArrayList<ILibraryProvider>();
        for (ILibraryProvider provider : LibraryProviderFramework.getProviders()) {
            if (provider.isAbstract() || provider.isHidden() || !provider.isEnabledFor(fproj, fv, this.customEnablementContextVariables)) continue;
            newProviders.add(provider);
        }
        Comparator comp = CollectionsUtil.getInvertingComparator();
        Collections.sort(newProviders, comp);
        IFacetedProject base = fproj instanceof IFacetedProject ? (IFacetedProject)fproj : ((IFacetedProjectWorkingCopy)fproj).getFacetedProject();
        if (base != null && base.hasProjectFacet(f)) {
            ILibraryProvider provider = LibraryProviderFramework.getCurrentProvider(base.getProject(), f);
            if (provider == null) {
                throw new RuntimeException();
            }
            if (!newProviders.contains(provider)) {
                newProviders.add(provider);
            }
        }
        this.providers = newProviders;
        this.providersReadOnly = Collections.unmodifiableList(this.providers);
        for (ILibraryProvider provider : this.providers) {
            LibraryProvider prov = (LibraryProvider)provider;
            LibraryProviderOperationConfig config = prov.createInstallOperationConfig(this);
            config.addListener(this.providerConfigListener, new String[0]);
            this.configs.put(provider, config);
        }
        ILibraryProvider oldSelectedProvider = this.selectedProvider;
        if (this.providers.size() > 0) {
            if (this.selectedProvider == null || this.isDefaultSelection || !this.providers.contains(this.selectedProvider)) {
                ILibraryProvider provider = LibraryProviderFrameworkImpl.get().getLastProviderUsed(fv);
                if (provider == null || !this.providers.contains(provider)) {
                    provider = this.providers.iterator().next();
                }
                this.setLibraryProvider(provider, true, false);
            }
        } else {
            this.setLibraryProvider(null, true, false);
        }
        this.notifyListeners(PROP_AVAILABLE_PROVIDERS, oldProviders, this.providersReadOnly);
        if (!MiscUtil.equal((Object)oldSelectedProvider, (Object)this.selectedProvider)) {
            this.notifyListeners(PROP_SELECTED_PROVIDER, oldSelectedProvider, this.selectedProvider);
        }
    }

    public synchronized void reset() {
        this.refresh();
        IProjectFacet facet = this.fv.getProjectFacet();
        IFacetedProject fpj = this.fproj instanceof IFacetedProject ? (IFacetedProject)this.fproj : ((IFacetedProjectWorkingCopy)this.fproj).getFacetedProject();
        ILibraryProvider provider = null;
        if (this.uninstallDelegate != null) {
            this.uninstallDelegate.dispose();
            this.uninstallDelegate = null;
        }
        if (fpj != null && fpj.hasProjectFacet(facet)) {
            this.uninstallDelegate = new LibraryUninstallDelegate((IFacetedProjectBase)fpj, this.fv);
            provider = LibraryProviderFramework.getCurrentProvider(fpj.getProject(), facet);
            if (provider == null) {
                throw new RuntimeException();
            }
        } else {
            provider = LibraryProviderFrameworkImpl.get().getLastProviderUsed(this.fv);
            if (provider == null || !this.providers.contains(provider)) {
                provider = !this.providers.isEmpty() ? this.providers.iterator().next() : null;
            }
        }
        this.setLibraryProvider(provider);
        for (LibraryProviderOperationConfig config : this.configs.values()) {
            config.reset();
        }
    }

    public synchronized IStatus validate() {
        IStatus st = Status.OK_STATUS;
        if (this.providers.size() == 0) {
            st = FacetedProjectFrameworkJavaPlugin.createErrorStatus(Resources.noProvidersAvailable);
        } else {
            LibraryProviderOperationConfig providerInstallOpConfig = this.configs.get(this.selectedProvider);
            if (providerInstallOpConfig instanceof LibraryProviderOperationConfig) {
                st = providerInstallOpConfig.validate();
            }
        }
        return st;
    }

    public synchronized void execute(IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)10);
        try {
            IFacetedProjectBase fproj = this.getFacetedProject();
            IProjectFacetVersion fv = this.getProjectFacetVersion();
            LibraryProvider provider = (LibraryProvider)this.getLibraryProvider();
            String rootLibraryProviderId = this.selectedProvider.getRootProvider().getId();
            if (rootLibraryProviderId.equals("unknown-library-provider") || rootLibraryProviderId.equals("legacy-library-provider")) {
                return;
            }
            if (this.uninstallDelegate != null) {
                this.uninstallDelegate.execute((IProgressMonitor)new NullProgressMonitor());
            }
            LibraryProviderOperation libraryInstallOp = provider.createOperation(LibraryProviderActionType.INSTALL);
            LibraryProviderOperationConfig libraryInstallOpConfig = this.getLibraryProviderOperationConfig();
            libraryInstallOp.execute(libraryInstallOpConfig, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)8));
            LibraryProviderFrameworkImpl.get().setLastProviderUsed(fv, provider);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            LibraryProviderFrameworkImpl.get().setCurrentProvider(fproj.getProject(), fv.getProjectFacet(), provider);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public synchronized void dispose() {
        if (this.uninstallDelegate != null) {
            this.uninstallDelegate.dispose();
        }
        this.getFacetedProject().removeListener(this.facetedProjectListener);
        for (LibraryProviderOperationConfig cfg : this.configs.values()) {
            try {
                cfg.dispose();
            }
            catch (Exception e) {
                FacetedProjectFrameworkJavaPlugin.log(e);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String noProvidersAvailable;

        static {
            Resources.initializeMessages((String)LibraryInstallDelegate.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

