/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public class CallbackSemaphore
implements SyncCallback {
    public static final long OPERATION_TIMEOUT_MS = 120000L;
    private final Semaphore sem = new Semaphore(0);
    private Exception savedException;

    public boolean tryAcquireDefault(RelayOk relayOk) throws MethodIsBlockingException {
        return this.tryAcquire(120000L, TimeUnit.MILLISECONDS);
    }

    public void acquireDefault(RelayOk relayOk) throws MethodIsBlockingException {
        boolean res = this.tryAcquireDefault(relayOk);
        if (!res) {
            throw new RuntimeException("Failed to acquire semaphore (timeout)");
        }
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws MethodIsBlockingException {
        boolean res;
        try {
            res = this.sem.tryAcquire(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.savedException != null) {
            throw new RuntimeException("Exception occured in callback", this.savedException);
        }
        return res;
    }

    @Override
    public void callbackDone(RuntimeException e) {
        this.savedException = e == null ? null : new Exception("Exception saved from callback", e);
        this.sem.release();
    }
}

