/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.npm.ui.internal.contentassist;

import java.text.MessageFormat;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.JSONSchemaType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.json.npm.ui.internal.editor.NPMEditorPluginImageHelper;
import org.eclipse.wst.json.ui.contentassist.ContentAssistHelper;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.contentassist.HttpCompletionProposalCollector;
import org.eclipse.wst.json.ui.contentassist.ICompletionProposalCollector;
import org.eclipse.wst.json.ui.contentassist.JSONKeyCompletionProposal;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;

public class NPMDependencyCompletionProposalCollector
extends HttpCompletionProposalCollector {
    public final String searchUrl = "https://typeahead.npmjs.com/search?q={0}";
    public final String packageUrl = "http://registry.npmjs.org/{0}/latest";

    protected String getUrl(ContentAssistRequest contentAssistRequest, ICompletionProposalCollector.TargetType target) {
        String keyword = contentAssistRequest.getMatchString();
        return MessageFormat.format("https://typeahead.npmjs.com/search?q={0}", keyword);
    }

    protected void addProposals(JsonValue json, ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, ICompletionProposalCollector.TargetType target) {
        if (json.isArray()) {
            String dependency = null;
            String replacementString = null;
            JsonArray values = (JsonArray)json;
            for (JsonValue value : values) {
                if (!value.isObject()) continue;
                dependency = ((JsonObject)value).get("value").asString();
                replacementString = ContentAssistHelper.getRequiredName((String)dependency, (JSONSchemaType)JSONSchemaType.String);
                Image icon = NPMEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/npm-16.png");
                JSONKeyCompletionProposal proposal = new JSONKeyCompletionProposal(replacementString, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), replacementString.length() - 2, icon, dependency, null, null, 400);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }
}

