/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractCompletionTest;

public class ReferenceTypeCompletionTest
extends AbstractCompletionTest {
    public ReferenceTypeCompletionTest(String testName) {
        super(testName);
    }

    public void testClassInstanceCreationExpression1() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tnew Xxx().zzz();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "function foo() {\n  new <CompleteOnType:X>().zzz();\n}\n", "X", "Xxx", "<complete on class instance creation expression 1>");
    }

    public void testClassInstanceCreationExpression2() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tnew Y(new Xxx()).zzz();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "function foo() {\n  new Y(new <CompleteOnType:X>()).zzz();\n}\n", "X", "Xxx", "<complete on class instance creation expression 2>");
    }

    public void testClassInstanceCreationExpression3() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tnew Y(1, true, new Xxx()).zzz();\t\n}\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "function foo() {\n  new Y(1, true, new <CompleteOnType:X>()).zzz();\n}\n", "X", "Xxx", "<complete on class instance creation expression 3>");
    }

    public void testInstanceOf() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\treturn this instanceof Xxx;\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "function foo() {\n  return (this instanceof <CompleteOnName:X>);\n}\n", "X", "Xxx", "<complete on instanceof>");
    }

    public void testTypeOf() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\treturn this typeof Xxx;\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnName:X>", "function foo() {\n  (typeof <CompleteOnName:X>);\n}\n;\n", "X", "Xxx", "<complete on instanceof>");
    }

    public void testQualifiedTypeReferenceShrinkAll() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar i = 0;\t\t\t\t\t\t\t\n\tnew a.b.c.Xxx();\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\tnew a", "<CompleteOnName:a>", "function foo() {\n  var i = 0;\n  new   <CompleteOnName:a>.b.c.Xxx();\n}\n", "a", "a", "<complete on qualified type reference (shrink all)>");
    }

    public void testQualifiedTypeReferenceShrinkAllButOne() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar i = 0;\t\t\t\t\t\t\t\n\tnew a.b.c.Xxx();\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "a.", "<CompleteOnMemberAccess:a.>", "function foo() {\n  var i = 0;\n  new   <CompleteOnMemberAccess:a.>.c.Xxx();\n}\n", "", "b", "<complete on qualified type reference (shrink all but one)>");
    }

    public void testQualifiedTypeReferenceShrinkNone() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar i = 0;\t\t\t\t\t\t\t\n\tnew a.b.c.Xxx();\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "X", "<CompleteOnMemberAccess:a.b.c.X>", "function foo() {\n  var i = 0;\n  new   <CompleteOnType:a.b.c.X>();\n}\n", "X", "Xxx", "<complete on qualified type reference (shrink none)>");
    }

    public void testQualifiedTypeReferenceShrinkOne() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar i = 0;\t\t\t\t\t\t\t\n\tnew a.b.c.Xxx();\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "a.b.c.", "<CompleteOnMemberAccess:a.b.c.>", "function foo() {\n  var i = 0;\n  new   <CompleteOnType:a.b.c.>();\n}\n", "", "Xxx", "<complete on qualified type reference (shrink one)>");
    }
}

