/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IViewRootHandle;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class TestDTFacesContext
extends TestCase {
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private WebProjectTestEnvironment _webProjectTestEnv;
    private IFile _testJSP;
    private static final String TESTJSP1_PATH = "testdata1.jsp";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this._webProjectTestEnv = new WebProjectTestEnvironment(this.getProjectName(), JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5"));
        this._webProjectTestEnv.createProject(false);
        this._webProjectTestEnv.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_2_0.xml.data", "/WEB-INF/faces-config.xml");
        IResource res = this._webProjectTestEnv.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", TESTJSP1_PATH);
        this._testJSP = (IFile)res;
        new JDTTestEnvironment((ProjectTestEnvironment)this._webProjectTestEnv);
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(this._webProjectTestEnv);
        this._jsfFactedTestEnvironment.initialize("2.0");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDTExternalContext() {
        DTFacesContext facesContext = this.getFacesContext(this._testJSP);
        TestDTFacesContext.assertNotNull((Object)facesContext);
        IDTExternalContext externalContext = facesContext.getDTExternalContext((IAdaptable)this._testJSP);
        TestDTFacesContext.assertNotNull((Object)externalContext);
        TestDTFacesContext.assertEquals((int)0, (int)externalContext.getNoneMap().size());
        TestDTFacesContext.assertEquals((int)2, (int)externalContext.getRequestMap().size());
        TestDTFacesContext.assertEquals((int)0, (int)externalContext.getSessionMap().size());
        TestDTFacesContext.assertEquals((int)0, (int)externalContext.getApplicationMap().size());
        TestDTFacesContext.assertEquals((String)this.getProjectName(), (String)externalContext.getRequestContextPath());
    }

    public void testGetViewRoot() {
        DTFacesContext facesContext = this.getFacesContext(this._testJSP);
        IViewRootHandle handle = facesContext.getViewRootHandle();
        DTUIViewRoot viewRoot = handle.updateViewRoot();
        TestDTFacesContext.assertNotNull((Object)viewRoot);
        TestDTFacesContext.assertEquals((String)"/testdata1.jsp", (String)viewRoot.getViewId());
        TestDTFacesContext.assertNotNull((Object)viewRoot.getViewMap());
    }

    public void _testAdaptContextObject() {
        DTFacesContext facesContext = this.getFacesContext(this._testJSP);
        IResource res = facesContext.adaptContextObject();
        TestDTFacesContext.assertEquals((Object)this._testJSP, (Object)res);
    }

    private DTFacesContext getFacesContext(IFile jspFile) {
        IProject project = this._webProjectTestEnv.getTestProject();
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)project);
        return manager.getFacesContext(jspFile);
    }

    private String getProjectName() {
        return "TestDesignTimeApplicationManager_" + this.getName();
    }
}

