/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.form;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.jsf.common.ui.internal.form.AbstractDetailsForm;
import org.eclipse.jst.jsf.common.ui.internal.form.AbstractMasterForm;
import org.eclipse.jst.jsf.common.ui.internal.form.BlankDetailsForm;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMasterDetailBlock
implements ISelectionChangedListener {
    private AbstractMasterForm _masterForm;
    private Composite _detailsPanel;
    private AbstractDetailsForm _curPage;
    private FormToolkit _toolkit;
    private StackLayout _detailLayout;
    private List<AbstractDetailsForm> _detailForms;
    private BlankDetailsForm _blankDetails;

    protected AbstractMasterDetailBlock() {
    }

    public final void dispose() {
        this._masterForm.dispose();
        for (AbstractDetailsForm detailsForm : this._detailForms) {
            detailsForm.dispose();
        }
        this.doDispose();
    }

    protected void doDispose() {
    }

    public final void createContent(FormToolkit toolkit, Form form) {
        this._toolkit = toolkit;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        form.getBody().setLayout((Layout)layout);
        SashForm sashForm = new SashForm(form.getBody(), 0);
        this._toolkit.adapt((Control)sashForm, false, false);
        sashForm.setMenu(form.getBody().getMenu());
        sashForm.setLayoutData((Object)new GridData(1808));
        this.initializeMasterPart(this._toolkit, (Composite)sashForm);
        this.createDetailsPart((Composite)sashForm);
        this._masterForm.createHead(form);
        this.createToolBarActions(form);
        form.updateToolBar();
    }

    protected abstract AbstractMasterForm createMasterPart(FormToolkit var1);

    private void initializeMasterPart(FormToolkit toolkit, Composite parent) {
        this._masterForm = this.createMasterPart(toolkit);
        this._masterForm.initialize(this);
        this._masterForm.createClientArea(parent);
    }

    private void createToolBarActions(Form form) {
        this._masterForm.contributeActions(form.getToolBarManager());
    }

    private void createDetailsPart(Composite parent) {
        this._detailsPanel = new Composite(parent, 0);
        this._detailLayout = new StackLayout();
        this._detailsPanel.setLayout((Layout)this._detailLayout);
        this._detailForms = this.createDetailPages();
        for (AbstractDetailsForm detailForm : this._detailForms) {
            detailForm.initialize(this._toolkit);
            detailForm.createContents(this._detailsPanel);
        }
        this._blankDetails = new BlankDetailsForm();
        this._blankDetails.initialize(this._toolkit);
        this._blankDetails.createContents(this._detailsPanel);
        this._curPage = this._blankDetails;
        this._detailLayout.topControl = this._curPage.getControl();
        this._detailsPanel.layout();
    }

    public final void selectionChanged(final SelectionChangedEvent event) {
        Object selectedObj = ((IStructuredSelection)event.getSelection()).getFirstElement();
        AbstractDetailsForm page = this.selectPage(selectedObj);
        if (page != null) {
            final AbstractDetailsForm fpage = page;
            BusyIndicator.showWhile((Display)this._detailsPanel.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    AbstractDetailsForm oldPage = AbstractMasterDetailBlock.this._curPage;
                    AbstractMasterDetailBlock.this._curPage = fpage;
                    if (oldPage != null && oldPage.isDirty()) {
                        oldPage.commit(false);
                    }
                    if (fpage.isStale()) {
                        fpage.refresh();
                    }
                    AbstractMasterDetailBlock.this._curPage.selectionChanged(event.getSelection());
                    ((AbstractMasterDetailBlock)AbstractMasterDetailBlock.this)._detailLayout.topControl = AbstractMasterDetailBlock.this._curPage.getControl();
                    AbstractMasterDetailBlock.this._detailsPanel.layout();
                }
            });
        }
    }

    protected abstract List<AbstractDetailsForm> createDetailPages();

    protected abstract AbstractDetailsForm doSelectPage(Object var1);

    private AbstractDetailsForm selectPage(Object forModel) {
        AbstractDetailsForm clientForm = this.doSelectPage(forModel);
        if (clientForm != null) {
            return clientForm;
        }
        return this._blankDetails;
    }
}

