/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.base;

import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.el.tests.base.MockELValidationReporter;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ELAssert
extends Assert {
    public static void assertContainsProblem(List<MockValidationReporter.ReportedProblem> problems, int code) {
        ELAssert.assertContainsProblem(problems, code, -1, -1);
    }

    public static String getELText(IStructuredDocument document, int docPos) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)document, docPos);
        if (context == null) {
            ELAssert.fail((String)"context is null");
        }
        ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
        return resolver.getRegionText();
    }

    public static ELExpressionValidator createELValidator(IStructuredDocument document, int docPos, IFile file, MockELValidationReporter reporter, IStructuredDocumentSymbolResolverFactory factory) {
        String elText = ELAssert.getELText(document, docPos);
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)document, docPos);
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        return new ELExpressionValidator(context, elText, factory, (IJSFViewValidator.IValidationReporter)reporter);
    }

    public static List<MockValidationReporter.ReportedProblem> assertSyntaxError(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, int expectedProblems) {
        return ELAssert.assertSyntaxProblems(document, factory, docPos, file, expectedProblems, 1);
    }

    public static List<MockValidationReporter.ReportedProblem> assertSyntaxWarning(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, int expectedProblems) {
        return ELAssert.assertSyntaxProblems(document, factory, docPos, file, expectedProblems, 2);
    }

    public static List<MockValidationReporter.ReportedProblem> assertSyntaxProblems(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, int expectedProblems, int expectedMaxSeverity) {
        MockELValidationReporter reporter = new MockELValidationReporter();
        ELExpressionValidator validator = ELAssert.createELValidator(document, docPos, file, reporter, factory);
        validator.validateXMLNode();
        List<MockValidationReporter.ReportedProblem> problems = reporter.getSyntaxProblems();
        ELAssert.assertEquals((int)expectedProblems, (int)problems.size());
        int worstSeverity = 0;
        for (MockValidationReporter.ReportedProblem problem : problems) {
            worstSeverity = ELAssert.maxSeverity(worstSeverity, problem.getSeverity());
        }
        ELAssert.assertEquals((int)expectedMaxSeverity, (int)worstSeverity);
        return problems;
    }

    public static void assertNoError(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, String expectedSignature) {
        ELAssert.assertNoError(document, factory, docPos, file, expectedSignature, -1);
    }

    public static void assertNoError(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, String expectedSignature, int assignability) {
        MockELValidationReporter reporter = new MockELValidationReporter();
        ELExpressionValidator validator = ELAssert.createELValidator(document, docPos, file, reporter, factory);
        validator.validateXMLNode();
        ELAssert.assertEquals((int)0, (int)reporter.getSyntaxProblems().size());
        ELAssert.assertEquals((int)0, (int)reporter.getSemanticProblems().size());
        if (expectedSignature != null) {
            ELAssert.assertNotNull((Object)validator.getExpressionType());
            ELAssert.assertEquals((String)expectedSignature, (String)validator.getExpressionType().getSignatures()[0]);
        }
        if (assignability >= 0) {
            ELAssert.assertEquals((int)assignability, (int)validator.getExpressionType().getAssignmentTypeMask());
        }
    }

    public static List<MockValidationReporter.ReportedProblem> assertSemanticError(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, String expectedSignature, int expectedProblems) {
        return ELAssert.assertSemanticProblems(document, factory, docPos, file, expectedSignature, expectedProblems, 1);
    }

    public static List<MockValidationReporter.ReportedProblem> assertSemanticWarning(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, String expectedSignature, int expectedProblems) {
        return ELAssert.assertSemanticProblems(document, factory, docPos, file, expectedSignature, expectedProblems, 2);
    }

    public static List<MockValidationReporter.ReportedProblem> assertSemanticInfo(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, String expectedSignature, int expectedProblems) {
        return ELAssert.assertSemanticProblems(document, factory, docPos, file, expectedSignature, expectedProblems, 4);
    }

    public static List<MockValidationReporter.ReportedProblem> assertSemanticProblems(IStructuredDocument document, IStructuredDocumentSymbolResolverFactory factory, int docPos, IFile file, String expectedSignature, int expectedProblems, int expectedMaxSeverity) {
        MockELValidationReporter reporter = new MockELValidationReporter();
        ELExpressionValidator validator = ELAssert.createELValidator(document, docPos, file, reporter, factory);
        validator.validateXMLNode();
        if (expectedSignature != null && validator.getExpressionType() != null) {
            ELAssert.assertEquals((String)expectedSignature, (String)validator.getExpressionType().getSignatures()[0]);
        }
        ELAssert.assertEquals((int)0, (int)reporter.getSyntaxProblems().size());
        List<MockValidationReporter.ReportedProblem> problems = reporter.getSemanticProblems();
        ELAssert.assertEquals((int)expectedProblems, (int)problems.size());
        int worstSeverity = 0;
        for (MockValidationReporter.ReportedProblem problem : problems) {
            worstSeverity = ELAssert.maxSeverity(worstSeverity, problem.getSeverity());
        }
        ELAssert.assertEquals((int)expectedMaxSeverity, (int)worstSeverity);
        return problems;
    }

    public static void assertContainsProblem(List<MockValidationReporter.ReportedProblem> problems, int code, int startPos, int length) {
        HashSet<Integer> probsFound = new HashSet<Integer>();
        for (MockValidationReporter.ReportedProblem problem : problems) {
            probsFound.add(new Integer(problem.getErrorCode()));
            if (problem.getErrorCode() != code) continue;
            ELAssert.assertTrue((String)"Offset of message must be >= 0", (problem.getOffset() >= 0 ? 1 : 0) != 0);
            ELAssert.assertTrue((String)"Length of message marker must be >=0", (problem.getLength() >= 0 ? 1 : 0) != 0);
            if (startPos >= 0) {
                ELAssert.assertEquals((String)"Offset must be == startPos", (int)startPos, (int)problem.getOffset());
                ELAssert.assertEquals((String)"Length must be == length", (int)problem.getLength(), (int)length);
            }
            return;
        }
        ELAssert.assertTrue((String)("Expected find error code matching " + code + " found " + ((Object)probsFound).toString()), (boolean)false);
    }

    static int maxSeverity(int sev1, int sev2) {
        if (sev1 == 0) {
            return sev2;
        }
        if (sev2 == 0) {
            return sev1;
        }
        return Math.min(sev1, sev2);
    }
}

