/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IPredefinedSourceWrapProvider;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.json.simple.JSONObject;

public class HardcodedSourceWrapProvider
implements IPredefinedSourceWrapProvider {
    private final List<IPredefinedSourceWrapProvider.Entry> entries = Arrays.asList(new NodeJsStandardEntry(), new NodeJsWithDefinedEntry());

    @Override
    public Collection<IPredefinedSourceWrapProvider.Entry> getWrappers() {
        return this.entries;
    }

    private static abstract class NodeJsBase
    extends IPredefinedSourceWrapProvider.Entry {
        protected static final String SUFFIX = "\n});";
        private final String prefix;

        NodeJsBase(String id, String name, String prefix) {
            super(id, new SourceWrapSupport.StringBasedWrapper(name, prefix, SUFFIX));
            this.prefix = prefix;
        }

        @Override
        public String getHumanDescription() {
            JSONObject object = new JSONObject();
            object.put((Object)"prefix", (Object)this.prefix);
            object.put((Object)"suffix", (Object)SUFFIX);
            return NLS.bind((String)Messages.HardcodedSourceWrapProvider_DESCRIPTION, (Object)this.getSpecialization(), (Object)object.toJSONString());
        }

        protected abstract String getSpecialization();
    }

    private static class NodeJsStandardEntry
    extends NodeJsBase {
        private static final String NAME = Messages.HardcodedSourceWrapProvider_STANDARD;
        private static final String PREFIX = "(function (exports, require, module, __filename, __dirname) { ";

        NodeJsStandardEntry() {
            super(NodeJsStandardEntry.class.getName(), NAME, PREFIX);
        }

        @Override
        protected String getSpecialization() {
            return Messages.HardcodedSourceWrapProvider_STANDARD_2;
        }
    }

    private static class NodeJsWithDefinedEntry
    extends NodeJsBase {
        private static final String NAME = Messages.HardcodedSourceWrapProvider_WITH_DEFINED_2;
        private static final String PREFIX = "(function (exports, require, module, __filename, __dirname, define) { ";

        NodeJsWithDefinedEntry() {
            super(NodeJsWithDefinedEntry.class.getName(), NAME, PREFIX);
        }

        @Override
        protected String getSpecialization() {
            return Messages.HardcodedSourceWrapProvider_WITH_DEFINED;
        }
    }
}

