/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.dtresourceprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.Messages;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.TrinidadTagSupportActivator;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DefaultDTResourceProvider;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DefaultDTSkin;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTSkin;
import org.osgi.framework.Bundle;

public class TrinidadDTResourceProvider
extends DefaultDTResourceProvider {
    private static final String ID = "http://myfaces.apache.org/trinidad";
    private static final String SKIN_MINIMAL = "minimal";
    private static final String SKIN_SIMPLE = "simple";
    private static final String STYLESHEET_MINIMAL = "/skinning/minimal.css";
    private static final String STYLESHEET_SIMPLE = "/skinning/simple.css";
    private static URL STYLESHEET_MINIMAL_URL;
    private static URL STYLESHEET_SIMPLE_URL;
    private static final String DTREZPROV_CACHE_DIRNAME = "dtRezProvCache";
    private static final String URI_DIRNAME = "myfaces.apache.org_trinidad";
    private static final String DIR_TO_COPY = "skinning/";

    public TrinidadDTResourceProvider() {
        super(ID);
        this.addSkin((IDTSkin)this.createSkin(SKIN_MINIMAL, STYLESHEET_MINIMAL_URL, true));
        this.addSkin((IDTSkin)this.createSkin(SKIN_SIMPLE, STYLESHEET_SIMPLE_URL, false));
    }

    private DefaultDTSkin createSkin(String name, URL stylesheetURL, boolean isDefault) {
        DefaultDTSkin skin = null;
        if (stylesheetURL != null) {
            skin = new DefaultDTSkin(name, Collections.singletonList(stylesheetURL));
            skin.setDefault(isDefault);
        } else {
            TrinidadTagSupportActivator.logError(Messages.TrinidadDTResourceProvider_StyleSheetNotLocated, null);
        }
        return skin;
    }

    public static void init() {
        block28: {
            try {
                STYLESHEET_MINIMAL_URL = FileLocator.toFileURL((URL)TrinidadDTResourceProvider.class.getResource(STYLESHEET_MINIMAL));
                STYLESHEET_SIMPLE_URL = FileLocator.toFileURL((URL)TrinidadDTResourceProvider.class.getResource(STYLESHEET_SIMPLE));
            }
            catch (IOException iOException) {}
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)TrinidadTagSupportActivator.getDefault().getBundle());
                if (!bundleFile.isFile()) break block28;
                try {
                    File simpleStylesheet;
                    File minimalStylesheet;
                    File targetDir;
                    block30: {
                        File stateLocation = TrinidadTagSupportActivator.getDefault().getStateLocation().toFile();
                        File dtRezProvCacheDir = new File(stateLocation, DTREZPROV_CACHE_DIRNAME);
                        targetDir = new File(dtRezProvCacheDir, URI_DIRNAME);
                        TrinidadDTResourceProvider.wipeDir(targetDir);
                        if (targetDir.mkdirs()) {
                            FileInputStream fis = null;
                            ZipInputStream jis = null;
                            FileOutputStream fos = null;
                            try {
                                try {
                                    fis = new FileInputStream(bundleFile);
                                    jis = new JarInputStream((InputStream)fis, false);
                                    JarEntry jarEntry = ((JarInputStream)jis).getNextJarEntry();
                                    while (jarEntry != null) {
                                        String name = jarEntry.getName();
                                        if (name != null && name.startsWith(DIR_TO_COPY)) {
                                            File targetFile = new File(targetDir, name);
                                            if (!jarEntry.isDirectory()) {
                                                File parentDir = targetFile.getParentFile();
                                                if (parentDir != null && !parentDir.exists()) {
                                                    parentDir.mkdirs();
                                                }
                                                if (targetFile.createNewFile()) {
                                                    fos = new FileOutputStream(targetFile);
                                                    byte[] buf = new byte[1024];
                                                    int bytesRead = ((JarInputStream)jis).read(buf, 0, 1024);
                                                    while (bytesRead > 0) {
                                                        fos.write(buf, 0, bytesRead);
                                                        bytesRead = ((JarInputStream)jis).read(buf, 0, 1024);
                                                    }
                                                }
                                            }
                                        }
                                        jarEntry = ((JarInputStream)jis).getNextJarEntry();
                                    }
                                }
                                catch (IOException iOException) {
                                    if (fos != null) {
                                        fos.close();
                                    }
                                    if (jis != null) {
                                        jis.close();
                                    }
                                    if (fis != null) {
                                        fis.close();
                                    }
                                    break block30;
                                }
                            }
                            catch (Throwable throwable) {
                                if (fos != null) {
                                    fos.close();
                                }
                                if (jis != null) {
                                    jis.close();
                                }
                                if (fis != null) {
                                    fis.close();
                                }
                                throw throwable;
                            }
                            if (fos != null) {
                                fos.close();
                            }
                            if (jis != null) {
                                jis.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    if ((minimalStylesheet = new File(targetDir, STYLESHEET_MINIMAL)).exists()) {
                        STYLESHEET_MINIMAL_URL = minimalStylesheet.toURL();
                    }
                    if ((simpleStylesheet = new File(targetDir, STYLESHEET_SIMPLE)).exists()) {
                        STYLESHEET_SIMPLE_URL = simpleStylesheet.toURL();
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
            catch (IOException iOException) {}
        }
    }

    private static void wipeDir(File targetDir) {
        if (targetDir != null && targetDir.exists()) {
            File[] files;
            File[] fileArray = files = targetDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    file.delete();
                } else {
                    TrinidadDTResourceProvider.wipeDir(file);
                }
                ++n2;
            }
            targetDir.delete();
        }
    }
}

