/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;

final class BinaryMethod
extends BinaryAttribute
implements JavaResourceMethod {
    private boolean constructor;
    private final Vector<String> parameterTypeNames = new Vector();
    private static final Transformer<ITypeBinding, String> TYPE_BINDING_DECLARATION_QUALIFIED_NAME = new TypeBindingDeclarationQualifiedName();

    BinaryMethod(JavaResourceType parent, IMethod method) {
        this(parent, new MethodAdapter(method));
    }

    private BinaryMethod(JavaResourceType parent, MethodAdapter adapter) {
        super(parent, adapter);
        this.constructor = this.buildConstructor();
        CollectionTools.addAll(this.parameterTypeNames, this.buildParameterTypeNames(adapter.getMethodBinding()));
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.METHOD;
    }

    @Override
    public void synchronizeWith(MethodDeclaration methodDeclaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update() {
        super.update();
        this.updateConstructor();
        this.updateParameterTypeNames();
    }

    public IMethod getElement() {
        return (IMethod)super.getElement();
    }

    @Override
    public String getMethodName() {
        return this.getElement().getElementName();
    }

    @Override
    public boolean isConstructor() {
        return this.constructor;
    }

    private boolean buildConstructor() {
        try {
            return this.getElement().isConstructor();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateConstructor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterable<String> getParameterTypeNames() {
        return IterableTools.cloneLive(this.parameterTypeNames);
    }

    @Override
    public String getParameterTypeName(int index) {
        return this.parameterTypeNames.get(index);
    }

    @Override
    public int getParametersSize() {
        return this.parameterTypeNames.size();
    }

    private Iterable<String> buildParameterTypeNames(IMethodBinding binding) {
        return binding == null ? EmptyIterable.instance() : IterableTools.transform((Iterable)IterableTools.iterable((Object[])binding.getParameterTypes()), TYPE_BINDING_DECLARATION_QUALIFIED_NAME);
    }

    private void updateParameterTypeNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(MethodSignature methodSignature, int occurrence) {
        throw new UnsupportedOperationException();
    }

    static class MethodAdapter
    implements BinaryAttribute.AttributeAdapter {
        private final IMethod method;
        private final IBinding binding;

        MethodAdapter(IMethod method) {
            this.method = method;
            this.binding = this.buildBinding();
        }

        protected IBinding buildBinding() {
            return ASTTools.createBinding((IMember)this.method);
        }

        public IMethod getElement() {
            return this.method;
        }

        @Override
        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.method.getAnnotations();
        }

        @Override
        public String getAttributeName() {
            return NameTools.convertGetterOrSetterMethodNameToPropertyName((String)this.method.getElementName());
        }

        public IMethodBinding getMethodBinding() {
            return this.binding.getKind() == 2 ? null : (IMethodBinding)this.binding;
        }

        @Override
        public ITypeBinding getTypeBinding() {
            IMethodBinding methodBinding = this.getMethodBinding();
            return methodBinding == null ? (ITypeBinding)this.binding : methodBinding.getReturnType();
        }
    }

    static class TypeBindingDeclarationQualifiedName
    extends TransformerAdapter<ITypeBinding, String> {
        TypeBindingDeclarationQualifiedName() {
        }

        public String transform(ITypeBinding typeBinding) {
            return typeBinding.getTypeDeclaration().getQualifiedName();
        }
    }
}

