/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.internal.resource.java.AbstractJavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;

public abstract class SourceModel
extends AbstractJavaResourceModel {
    protected SourceModel(JavaResourceModel parent) {
        super(parent);
    }

    @Override
    public JavaResourceCompilationUnit getJavaResourceCompilationUnit() {
        return (JavaResourceCompilationUnit)this.getRoot();
    }

    protected void nestedAnnotationAdded(String listName, int index, NestableAnnotation addedAnnotation) {
        this.fireItemAdded(listName, index, addedAnnotation);
    }

    protected void nestedAnnotationsRemoved(String listName, int index, List<? extends NestableAnnotation> removedAnnotations) {
        this.fireItemsRemoved(listName, index, removedAnnotations);
    }

    @Override
    protected AnnotationProvider getAnnotationProvider() {
        return super.getAnnotationProvider();
    }

    protected abstract class AnnotationContainer<A extends NestableAnnotation> {
        protected final Vector<A> nestedAnnotations = new Vector();

        protected AnnotationContainer() {
        }

        protected abstract String getElementName();

        protected abstract String getNestedAnnotationName();

        protected abstract A buildNestedAnnotation(int var1);

        public void initializeFromContainerAnnotation(Annotation astContainerAnnotation) {
            ArrayList<Annotation> astAnnotations = this.getNestedAstAnnotations(astContainerAnnotation);
            int size = astAnnotations.size();
            int i = 0;
            while (i < size) {
                A nestedAnnotation = this.buildNestedAnnotation(i);
                this.nestedAnnotations.add(i, nestedAnnotation);
                nestedAnnotation.initialize(astAnnotations.get(i));
                ++i;
            }
        }

        public void synchronize(Annotation astContainerAnnotation) {
            ArrayList<Annotation> astAnnotations = this.getNestedAstAnnotations(astContainerAnnotation);
            Iterator<Annotation> astAnnotationStream = astAnnotations.iterator();
            for (NestableAnnotation nestedAnnotation : this.getNestedAnnotations()) {
                if (astAnnotationStream.hasNext()) {
                    nestedAnnotation.synchronizeWith(astAnnotationStream.next());
                    continue;
                }
                this.syncRemoveNestedAnnotations(astAnnotations.size());
                return;
            }
            while (astAnnotationStream.hasNext()) {
                this.syncAddNestedAnnotation(astAnnotationStream.next());
            }
        }

        public ListIterable<A> getNestedAnnotations() {
            return IterableTools.cloneLive(this.nestedAnnotations);
        }

        public int getNestedAnnotationsSize() {
            return this.nestedAnnotations.size();
        }

        public A getNestedAnnotation(int index) {
            return (A)((NestableAnnotation)this.nestedAnnotations.get(index));
        }

        public A addNestedAnnotation(int index) {
            int sourceIndex = this.nestedAnnotations.size();
            A nestedAnnotation = this.buildNestedAnnotation(sourceIndex);
            this.nestedAnnotations.add(sourceIndex, nestedAnnotation);
            nestedAnnotation.newAnnotation();
            this.moveNestedAnnotation(index, sourceIndex);
            return nestedAnnotation;
        }

        public A moveNestedAnnotation(int targetIndex, int sourceIndex) {
            if (targetIndex != sourceIndex) {
                return this.moveNestedAnnotation_(targetIndex, sourceIndex);
            }
            return null;
        }

        public A removeNestedAnnotation(int index) {
            NestableAnnotation nestedAnnotation = (NestableAnnotation)this.nestedAnnotations.remove(index);
            nestedAnnotation.removeAnnotation();
            this.syncAstAnnotationsAfterRemove(index);
            return (A)nestedAnnotation;
        }

        private A moveNestedAnnotation_(int targetIndex, int sourceIndex) {
            NestableAnnotation nestedAnnotation = (NestableAnnotation)((Vector)ListTools.move(this.nestedAnnotations, (int)targetIndex, (int)sourceIndex)).get(targetIndex);
            this.syncAstAnnotationsAfterMove(targetIndex, sourceIndex, nestedAnnotation);
            return (A)nestedAnnotation;
        }

        private ArrayList<Annotation> getNestedAstAnnotations(Annotation astContainerAnnotation) {
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            if (astContainerAnnotation != null && !astContainerAnnotation.isMarkerAnnotation()) {
                MemberValuePair pair;
                if (astContainerAnnotation.isSingleMemberAnnotation()) {
                    if (this.getElementName().equals("value")) {
                        Expression ex = ((SingleMemberAnnotation)astContainerAnnotation).getValue();
                        this.addAstAnnotationsTo(ex, result);
                    }
                } else if (astContainerAnnotation.isNormalAnnotation() && (pair = this.getMemberValuePair((NormalAnnotation)astContainerAnnotation)) != null) {
                    this.addAstAnnotationsTo(pair.getValue(), result);
                }
            }
            return result;
        }

        private void addAstAnnotationsTo(Expression expression, ArrayList<Annotation> astAnnotations) {
            if (expression != null) {
                if (expression.getNodeType() == 4) {
                    this.addAstAnnotationsTo((ArrayInitializer)expression, astAnnotations);
                } else {
                    Annotation astAnnotation = this.getAstAnnotation_(expression);
                    if (astAnnotation != null) {
                        astAnnotations.add(astAnnotation);
                    }
                }
            }
        }

        private void addAstAnnotationsTo(ArrayInitializer arrayInitializer, ArrayList<Annotation> astAnnotations) {
            List<Expression> expressions = this.expressions(arrayInitializer);
            for (Expression expression : expressions) {
                Annotation astAnnotation = this.getAstAnnotation(expression);
                if (astAnnotation == null) continue;
                astAnnotations.add(astAnnotation);
            }
        }

        private List<Expression> expressions(ArrayInitializer arrayInitializer) {
            return arrayInitializer.expressions();
        }

        private Annotation getAstAnnotation(Expression expression) {
            return expression == null ? null : this.getAstAnnotation_(expression);
        }

        private Annotation getAstAnnotation_(Expression expression) {
            switch (expression.getNodeType()) {
                case 77: 
                case 78: 
                case 79: {
                    Annotation astAnnotation = (Annotation)expression;
                    if (this.getQualifiedName(astAnnotation).equals(this.getNestedAnnotationName())) {
                        return astAnnotation;
                    }
                    return null;
                }
            }
            return null;
        }

        private String getQualifiedName(Annotation astAnnotation) {
            String resolvedName;
            ITypeBinding typeBinding = astAnnotation.resolveTypeBinding();
            if (typeBinding != null && (resolvedName = typeBinding.getQualifiedName()) != null) {
                return resolvedName;
            }
            return astAnnotation.getTypeName().getFullyQualifiedName();
        }

        private MemberValuePair getMemberValuePair(NormalAnnotation annotation) {
            List<MemberValuePair> pairs = this.values(annotation);
            for (MemberValuePair pair : pairs) {
                if (!pair.getName().getFullyQualifiedName().equals(this.getElementName())) continue;
                return pair;
            }
            return null;
        }

        private List<MemberValuePair> values(NormalAnnotation na) {
            return na.values();
        }

        private void syncAstAnnotationsAfterMove(int targetIndex, int sourceIndex, A nestedAnnotation) {
            nestedAnnotation.moveAnnotation(this.nestedAnnotations.size());
            if (sourceIndex < targetIndex) {
                int i = sourceIndex;
                while (i < targetIndex) {
                    ((NestableAnnotation)this.nestedAnnotations.get(i)).moveAnnotation(i);
                    ++i;
                }
            } else {
                int i = sourceIndex;
                while (i > targetIndex) {
                    ((NestableAnnotation)this.nestedAnnotations.get(i)).moveAnnotation(i);
                    --i;
                }
            }
            nestedAnnotation.moveAnnotation(targetIndex);
        }

        private void syncAstAnnotationsAfterRemove(int index) {
            int i = index;
            while (i < this.nestedAnnotations.size()) {
                ((NestableAnnotation)this.nestedAnnotations.get(i)).moveAnnotation(i);
                ++i;
            }
        }

        void syncAddNestedAnnotation(Annotation astAnnotation) {
            int index = this.nestedAnnotations.size();
            A nestedAnnotation = this.buildNestedAnnotation(index);
            nestedAnnotation.initialize(astAnnotation);
            this.nestedAnnotations.add(index, nestedAnnotation);
            this.nestedAnnotationAdded(index, nestedAnnotation);
        }

        void nestedAnnotationAdded(int index, A addedAnnotation) {
            SourceModel.this.nestedAnnotationAdded(this.getNestedAnnotationsListName(), index, (NestableAnnotation)addedAnnotation);
        }

        void syncRemoveNestedAnnotations(int index) {
            List<A> subList = this.nestedAnnotations.subList(index, this.nestedAnnotations.size());
            ArrayList<A> removedAnnotations = new ArrayList<A>(subList);
            subList.clear();
            this.nestedAnnotationsRemoved(index, removedAnnotations);
        }

        void nestedAnnotationsRemoved(int index, List<A> removedAnnotations) {
            SourceModel.this.nestedAnnotationsRemoved(this.getNestedAnnotationsListName(), index, removedAnnotations);
        }

        protected abstract String getNestedAnnotationsListName();

        public boolean isEmpty() {
            return this.nestedAnnotations.isEmpty();
        }

        AnnotationProvider getAnnotationProvider() {
            return SourceModel.this.getAnnotationProvider();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.nestedAnnotations);
        }
    }
}

