/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.internal.utility;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IAnnotationProvider;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IEJBGenerator;
import org.osgi.framework.Bundle;

public class AnnotationUtilities {
    public static IConfigurationElement findAnnotationProviderConfigurationByName(String id) {
        IConfigurationElement[] configurationElement = AnnotationUtilities.getGeneratorExtensions();
        int i = 0;
        while (i < configurationElement.length) {
            IConfigurationElement element = configurationElement[i];
            String providerID = element.getAttribute("name");
            if ("provider".equals(element.getName()) && providerID != null && providerID.equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static IAnnotationProvider findAnnotationProviderByName(String id) throws InvalidRegistryObjectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        IConfigurationElement[] configurationElement = AnnotationUtilities.getGeneratorExtensions();
        int i = 0;
        while (i < configurationElement.length) {
            IConfigurationElement element = configurationElement[i];
            String emitterId = element.getAttribute("name");
            if ("provider".equals(element.getName()) && emitterId != null && emitterId.equals(id)) {
                String pluginDescriptor = element.getDeclaringExtension().getContributor().getName();
                Bundle bundle = Platform.getBundle((String)pluginDescriptor);
                Class c = bundle.loadClass(element.getAttribute("class"));
                IAnnotationProvider provider = (IAnnotationProvider)c.newInstance();
                return provider;
            }
            ++i;
        }
        return null;
    }

    public static IEJBGenerator findEjbGeneratorByName(String id) throws InvalidRegistryObjectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        IConfigurationElement[] configurationElement = AnnotationUtilities.getGeneratorExtensions();
        int i = 0;
        while (i < configurationElement.length) {
            IConfigurationElement element = configurationElement[i];
            String generatorID = element.getAttribute("name");
            if ("ejbGenerator".equals(element.getName()) && generatorID != null && generatorID.equals(id)) {
                String pluginDescriptor = element.getDeclaringExtension().getContributor().getName();
                Bundle bundle = Platform.getBundle((String)pluginDescriptor);
                Class c = bundle.loadClass(element.getAttribute("class"));
                IEJBGenerator provider = (IEJBGenerator)c.newInstance();
                return provider;
            }
            ++i;
        }
        return null;
    }

    public static IConfigurationElement[] getGeneratorExtensions() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jst.j2ee.ejb.annotation.model.ejbGenerator");
        return configurationElements;
    }

    public static String[] getProviderNames() {
        IConfigurationElement[] configurationElement = AnnotationUtilities.getGeneratorExtensions();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < configurationElement.length) {
            IConfigurationElement element = configurationElement[i];
            if ("provider".equals(element.getName())) {
                names.add(element.getAttribute("name"));
            }
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }
}

