/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.cleanup;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupHandlerFactory;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.cleanup.StructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.w3c.dom.Node;

public class HTMLCleanupProcessorImpl
extends AbstractStructuredCleanupProcessor {
    private IStructuredCleanupPreferences fCleanupPreferences = null;

    protected String getContentType() {
        return ContentTypeIdForHTML.ContentTypeID_HTML;
    }

    protected IStructuredCleanupHandler getCleanupHandler(Node node) {
        return HTMLCleanupHandlerFactory.getInstance().createHandler(node, this.getCleanupPreferences());
    }

    public IStructuredCleanupPreferences getCleanupPreferences() {
        if (this.fCleanupPreferences == null) {
            this.fCleanupPreferences = new StructuredCleanupPreferences();
            Preferences preferences = this.getModelPreferences();
            if (preferences != null) {
                this.fCleanupPreferences.setTagNameCase(preferences.getInt("cleanupTagNameCase"));
                this.fCleanupPreferences.setAttrNameCase(preferences.getInt("cleanupAttrNameCase"));
                this.fCleanupPreferences.setCompressEmptyElementTags(preferences.getBoolean("compressEmptyElementTags"));
                this.fCleanupPreferences.setInsertRequiredAttrs(preferences.getBoolean("insertRequiredAttrs"));
                this.fCleanupPreferences.setInsertMissingTags(preferences.getBoolean("insertMissingTags"));
                this.fCleanupPreferences.setQuoteAttrValues(preferences.getBoolean("quoteAttrValues"));
                this.fCleanupPreferences.setFormatSource(preferences.getBoolean("formatSource"));
                this.fCleanupPreferences.setConvertEOLCodes(preferences.getBoolean("convertEOLCodes"));
                this.fCleanupPreferences.setEOLCode(preferences.getString("cleanupEOLCode"));
            }
        }
        return this.fCleanupPreferences;
    }

    protected IStructuredFormatProcessor getFormatProcessor() {
        return new HTMLFormatProcessorImpl();
    }

    protected Preferences getModelPreferences() {
        return HTMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void refreshCleanupPreferences() {
        this.fCleanupPreferences = null;
    }
}

