/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class TypeTests
extends TestCase {
    private static final String TEST_NAME = "Test JavaScript Type Content Assist";
    private static TestProjectSetup fTestProjectSetup;

    public TypeTests() {
        super(TEST_NAME);
    }

    public TypeTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(TypeTests.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false);
        return fTestProjectSetup;
    }

    public void testCamelCase_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClassesII.html", 8, 2, expectedProposals);
    }

    public void testCamelCase_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.CeleronXSeries - Computer.proc", "Installed.CorelXSoftware - Installed"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClassesII.html", 10, 2, expectedProposals);
    }

    public void testCamelCase_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClassesII.html", 12, 3, expectedProposals);
    }

    public void testClassProperties_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClassesII.html", 14, 4, expectedProposals);
    }

    public void testClassProperties_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"Installed : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClassesII.html", 16, 3, expectedProposals);
    }
}

