/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.easymock.internal.MethodSerializationWrapper;

public final class ClassMockingData
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final InvocationHandler handler;
    private transient Set<Method> mockedMethods;

    public ClassMockingData(InvocationHandler handler, Method ... mockedMethods) {
        this.handler = handler;
        this.mockedMethods = mockedMethods == null ? null : new HashSet<Method>(Arrays.asList(mockedMethods));
    }

    public boolean isMocked(Method method) {
        if (this.mockedMethods == null) {
            return true;
        }
        if (Modifier.isAbstract(method.getModifiers())) {
            return true;
        }
        return this.mockedMethods.contains(method);
    }

    public InvocationHandler handler() {
        return this.handler;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Set methods = (Set)stream.readObject();
        if (methods == null) {
            return;
        }
        this.mockedMethods = new HashSet<Method>(methods.size());
        for (MethodSerializationWrapper m : methods) {
            try {
                this.mockedMethods.add(m.getMethod());
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.mockedMethods == null) {
            stream.writeObject(null);
            return;
        }
        HashSet<MethodSerializationWrapper> methods = new HashSet<MethodSerializationWrapper>(this.mockedMethods.size());
        for (Method m : this.mockedMethods) {
            methods.add(new MethodSerializationWrapper(m));
        }
        stream.writeObject(methods);
    }
}

