/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class MapKeyMetadata
extends ORMetadata {
    private String m_name;

    public MapKeyMetadata() {
        super("<map-key>");
    }

    public MapKeyMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public MapKeyMetadata(MetadataAnnotation mapKey, MetadataAccessor accessor) {
        super(mapKey, accessor);
        this.m_name = mapKey.getAttributeString("name");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MapKeyMetadata) {
            MapKeyMetadata mapKey = (MapKeyMetadata)objectToCompare;
            return this.valuesMatch(this.m_name, mapKey.getName());
        }
        return false;
    }

    public boolean hasName() {
        return this.m_name != null && !this.m_name.equals("");
    }

    public String process(ContainerMapping mapping, MappingAccessor mappingAccessor) {
        MetadataDescriptor referenceDescriptor = mappingAccessor.getReferenceDescriptor();
        MetadataLogger logger = mappingAccessor.getLogger();
        if (!this.hasName() && referenceDescriptor.hasCompositePrimaryKey()) {
            return null;
        }
        String fieldOrPropertyName = MetadataHelper.getName(this.m_name, referenceDescriptor.getIdAttributeName(), "metadata_default_map_key_attribute_name", logger, mappingAccessor.getAnnotatedElementName());
        MappingAccessor referenceAccessor = referenceDescriptor.getMappingAccessor(fieldOrPropertyName);
        if (referenceAccessor == null) {
            if (referenceDescriptor.isMappedSuperclass()) {
                return null;
            }
            throw ValidationException.couldNotFindMapKey((String)fieldOrPropertyName, (Object)referenceDescriptor.getJavaClass(), (DatabaseMapping)((DatabaseMapping)mapping));
        }
        return referenceAccessor.getAccessibleObjectName();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

