/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.grunt.internal.launch.shortcut;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.build.system.launch.LaunchConfigurationAutoFill;
import org.eclipse.wst.jsdt.js.grunt.GruntPlugin;
import org.eclipse.wst.jsdt.js.grunt.internal.GruntTask;

public class GruntLaunch
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            element.toString();
            if (element instanceof ITask) {
                ITask task = (ITask)element;
                this.launch(task, mode);
            } else if (element instanceof IFile) {
                this.launch(this.createDefaultTask((IFile)element), mode);
            }
        }
    }

    public void launch(IEditorPart arg0, String arg1) {
    }

    protected void launch(ITask task, String mode) {
        try {
            ILaunchConfiguration[] existingConfigurations;
            IFile buildFile = task.getBuildFile();
            ILaunchConfigurationType gruntLaunchConfiguraionType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.jsdt.js.grunt.gruntLaunchConfigurationType");
            ILaunchConfiguration[] configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(gruntLaunchConfiguraionType);
            ILaunchConfiguration[] iLaunchConfigurationArray = existingConfigurations = LaunchConfigurationAutoFill.getAllLaunchConfigurations((ILaunchConfiguration[])configurations, (ITask)task, (String)"org.eclipse.wst.jsdt.js.grunt.BUILD_FILE");
            int n = existingConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration conf = iLaunchConfigurationArray[n2];
                if (conf.getAttribute("org.eclipse.wst.jsdt.js.grunt.COMMAND", null).equals(task.getName())) {
                    DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
                    return;
                }
                ++n2;
            }
            if (buildFile != null) {
                IProject project = buildFile.getProject();
                ILaunchConfigurationWorkingCopy newConfiguration = this.createEmptyLaunchConfiguration(String.valueOf(project.getName()) + " - " + task.getName() + " [" + buildFile.getName() + "]");
                newConfiguration.setAttribute("org.eclipse.wst.jsdt.js.grunt.BUILD_FILE", buildFile.getLocation().toOSString());
                newConfiguration.setAttribute("org.eclipse.wst.jsdt.js.grunt.PROJECT", project.getName());
                newConfiguration.setAttribute("org.eclipse.wst.jsdt.js.grunt.DIR", buildFile.getParent().getLocation().toOSString());
                newConfiguration.setAttribute("org.eclipse.wst.jsdt.js.grunt.COMMAND", task.getName());
                newConfiguration.doSave();
                DebugUITools.launch((ILaunchConfiguration)newConfiguration, (String)mode);
            }
        }
        catch (CoreException e) {
            GruntPlugin.logError(e, e.getMessage());
        }
    }

    private ILaunchConfigurationWorkingCopy createEmptyLaunchConfiguration(String namePrefix) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.js.grunt.gruntLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, launchManager.generateLaunchConfigurationName(namePrefix));
        return launchConfiguration;
    }

    private ITask createDefaultTask(IFile resource) {
        return new GruntTask("", resource, true, null);
    }
}

