/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.provisional.contentassist.AbstractXMLElementContentAssistRequest;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathElementContentAssist
extends AbstractXMLElementContentAssistRequest {
    public XPathElementContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        IDOMDocument domDocument = (IDOMDocument)this.node.getOwnerDocument();
        this.getXPathXMLElementProposals(domDocument);
        return this.getAllCompletionProposals();
    }

    private void getXPathXMLElementProposals(IDOMDocument domDocument) {
        try {
            Node ancestorNode = XSLTXPathHelper.selectSingleNode((Node)this.getNode(), (String)"ancestor::xsl:*[1]");
            Iterator<CMNode> cmNodeIt = this.getAvailableContentNodes(domDocument, ancestorNode, 2);
            this.createXPathXMLProposals(ancestorNode, cmNodeIt);
        }
        catch (Exception ex) {
            XSLUIPlugin.log(ex);
        }
    }

    private void createXPathXMLProposals(Node ancestorNode, Iterator<CMNode> cmNodeIt) {
        while (cmNodeIt.hasNext()) {
            CustomCompletionProposal proposal;
            CMNode cmNode = cmNodeIt.next();
            String proposedText = this.getRequiredName(ancestorNode, cmNode);
            if (proposedText.contains("xsl:") || proposedText.contains("xslt:")) continue;
            int offset = this.getReplacementBeginPosition();
            Image image = this.getCMNodeImage(cmNode);
            int startLength = this.getCursorPosition() - offset;
            String additionalInfo = this.getInfoProvider().getInfo(cmNode);
            if (this.matchString.length() > 0) {
                if (!proposedText.startsWith(this.matchString)) continue;
                proposal = this.createProposal(proposedText, additionalInfo, offset, image, startLength);
                this.addProposal((ICompletionProposal)proposal);
                continue;
            }
            proposal = this.createProposal(proposedText, additionalInfo, offset, image, startLength);
            this.addProposal((ICompletionProposal)proposal);
        }
    }
}

