/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.protocol;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.Version;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8ContextFilter;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8Protocol;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.VersionBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ContextHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ObjectValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.PropertyObject;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.PropertyWithRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.PropertyWithValue;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ScriptHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.DataWithRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyType;
import org.json.simple.JSONObject;

public class V8ProtocolUtil {
    public static Script.Type getScriptType(Long typeNumber) {
        if (typeNumber == null) {
            return null;
        }
        switch (typeNumber.intValue()) {
            case 4: {
                return Script.Type.NORMAL;
            }
            case 1: {
                return Script.Type.NATIVE;
            }
            case 2: {
                return Script.Type.EXTENSION;
            }
        }
        throw new IllegalArgumentException("unknown script type: " + typeNumber);
    }

    public static Long getObjectRef(SomeRef child) {
        if (child == null) {
            return null;
        }
        return child.ref();
    }

    public static List<? extends PropertyReference> extractObjectProperties(ObjectValueHandle handle) {
        List<PropertyObject> props = handle.properties();
        int propsLen = props.size();
        ArrayList<PropertyReference> objProps = new ArrayList<PropertyReference>(propsLen);
        int i = 0;
        while (i < propsLen) {
            PropertyObject prop = props.get(i);
            V8ProtocolUtil.putMirror(objProps, prop, PropertyNameGetter.SUBPROPERTY);
            ++i;
        }
        return objProps;
    }

    public static List<? extends PropertyReference> extractObjectInternalProperties(ObjectValueHandle handle) {
        List<PropertyObject> props;
        ArrayList<PropertyReference> objProps = new ArrayList<PropertyReference>(3);
        SomeRef protoObject = handle.protoObject();
        if (protoObject != null) {
            V8ProtocolUtil.putMirror(objProps, protoObject, PropertyNameGetter.PROTO_OBJECT);
        }
        if ((props = handle.internalProperties()) != null) {
            int i = 0;
            while (i < props.size()) {
                PropertyObject prop = props.get(i);
                V8ProtocolUtil.putMirror(objProps, prop, PropertyNameGetter.PRIMITIVE_VALUE);
                ++i;
            }
        }
        return objProps;
    }

    public static List<DataWithRef> extractAllPropertyRefs(ObjectValueHandle handle) {
        final ArrayList<PropertyReference> properties = new ArrayList<PropertyReference>();
        properties.addAll(V8ProtocolUtil.extractObjectProperties(handle));
        properties.addAll(V8ProtocolUtil.extractObjectInternalProperties(handle));
        return new AbstractList<DataWithRef>(){

            @Override
            public int size() {
                return properties.size();
            }

            @Override
            public DataWithRef get(int index) {
                return ((PropertyReference)properties.get(index)).getValueObject();
            }
        };
    }

    public static <OBJ> void putMirror(List<PropertyReference> refs, OBJ propertyObject, PropertyNameGetter<OBJ> nameGetter) {
        PropertyReference propertyRef = V8ProtocolUtil.extractProperty(propertyObject, nameGetter);
        if (propertyRef != null) {
            refs.add(propertyRef);
        }
    }

    public static <OBJ> PropertyReference extractProperty(OBJ prop, PropertyNameGetter<OBJ> nameGetter) {
        int propTypeValue;
        Object name = nameGetter.getName(prop);
        if (name == null) {
            return null;
        }
        if (V8ProtocolUtil.isInternalProperty(name)) {
            return null;
        }
        DataWithRef propValue = nameGetter.getRef(prop);
        Long propType = nameGetter.getPropertyType(prop);
        int n = propTypeValue = propType != null ? propType.intValue() : PropertyType.NORMAL.value;
        if (propTypeValue == PropertyType.FIELD.value || propTypeValue == PropertyType.CONSTANT_FUNCTION.value || propTypeValue == PropertyType.CALLBACKS.value || propTypeValue == PropertyType.NORMAL.value) {
            return new PropertyReference(name, propValue);
        }
        return null;
    }

    public static boolean isInternalProperty(Object propertyName) {
        if (!(propertyName instanceof String)) {
            return false;
        }
        String propertyNameStr = (String)propertyName;
        return propertyNameStr.length() == 0 || propertyNameStr.startsWith(".");
    }

    public static String getFunctionName(JSONObject functionObject) {
        if (functionObject == null) {
            return "<unknown>";
        }
        String name = V8ProtocolUtil.getNameOrInferred(functionObject, V8Protocol.LOCAL_NAME);
        if (V8ProtocolUtil.isNullOrEmpty(name)) {
            return "(anonymous function)";
        }
        return name;
    }

    public static Long getScriptIdFromResponse(ScriptHandle scriptObject) {
        return scriptObject.id();
    }

    public static ScriptHandle validScript(ScriptHandle script, List<SomeHandle> refs, V8ContextFilter contextFilter) {
        Long contextRef = V8ProtocolUtil.getObjectRef(script.context());
        int i = 0;
        int size = refs.size();
        while (i < size) {
            SomeHandle ref = refs.get(i);
            if (ref.handle() == contextRef.longValue()) {
                ContextHandle contextHandle;
                try {
                    contextHandle = ref.asContextHandle();
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                if (!contextFilter.isContextOurs(contextHandle)) {
                    return null;
                }
                return script;
            }
            ++i;
        }
        return null;
    }

    public static Version parseVersionResponse(SuccessCommandResponse versionResponse) {
        VersionBody body;
        try {
            body = versionResponse.body().asVersionBody();
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException(e);
        }
        String versionString = body.getV8Version();
        if (versionString == null) {
            return null;
        }
        return Version.parseString(versionString);
    }

    public static String getExceptionString(JsValue exception) {
        return exception.getValueString();
    }

    private static String getNameOrInferred(JSONObject obj, V8Protocol nameProperty) {
        String name = JsonUtil.getAsString(obj, nameProperty);
        if (V8ProtocolUtil.isNullOrEmpty(name)) {
            name = JsonUtil.getAsString(obj, V8Protocol.INFERRED_NAME);
        }
        return name;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static abstract class PropertyNameGetter<OBJ> {
        static final PropertyNameGetter<PropertyObject> LOCAL = new SubpropertyNameGetter(){

            @Override
            Object getName(PropertyObject ref) {
                Object name = super.getName(ref);
                if (V8ProtocolUtil.isInternalProperty(name)) {
                    return null;
                }
                return name;
            }
        };
        public static final PropertyNameGetter<SomeRef> THIS = new SimpleNameGetter("this");
        static final PropertyNameGetter<SomeRef> PROTO_OBJECT = new SimpleNameGetter("__proto__");
        static final PropertyNameGetter<PropertyObject> PRIMITIVE_VALUE = new SubpropertyNameGetter();
        public static final PropertyNameGetter<PropertyObject> SUBPROPERTY = new SubpropertyNameGetter();

        abstract DataWithRef getRef(OBJ var1);

        abstract Object getName(OBJ var1);

        abstract Long getPropertyType(OBJ var1);

        static class SimpleNameGetter
        extends PropertyNameGetter<SomeRef> {
            private final String name;

            SimpleNameGetter(String name) {
                this.name = name;
            }

            String getName(SomeRef ref) {
                return this.name;
            }

            @Override
            DataWithRef getRef(SomeRef someRef) {
                return DataWithRef.fromSomeRef(someRef);
            }

            @Override
            Long getPropertyType(SomeRef someRef) {
                return null;
            }
        }

        static class SubpropertyNameGetter
        extends PropertyNameGetter<PropertyObject> {
            SubpropertyNameGetter() {
            }

            @Override
            Object getName(PropertyObject ref) {
                return ref.name();
            }

            @Override
            DataWithRef getRef(PropertyObject prop) {
                PropertyWithValue asPropertyWithValue = prop.asPropertyWithValue();
                if (asPropertyWithValue != null) {
                    return DataWithRef.fromSomeRef(asPropertyWithValue.value());
                }
                return DataWithRef.fromLong(prop.asPropertyWithRef().ref());
            }

            @Override
            Long getPropertyType(PropertyObject prop) {
                PropertyWithRef asPropertyWithRef = prop.asPropertyWithRef();
                if (asPropertyWithRef == null) {
                    return null;
                }
                return asPropertyWithRef.propertyType();
            }
        }
    }
}

