/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.ObjectReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.PropertyImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.StackFrameImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;

public class ObjectReferenceImpl
extends MirrorImpl
implements ObjectReference {
    protected static final ArrayList NO_PROPERTIES = new ArrayList(0);
    private final String className;
    private final Number constructorRef;
    private final Number prototypeRef;
    private final Number id;
    protected StackFrameImpl frame;
    private Value constructor = null;
    private Value prototype = null;
    private List properties = null;

    public ObjectReferenceImpl(VirtualMachineImpl vm, Map body, StackFrameImpl frame) {
        super(vm);
        this.frame = frame;
        this.className = (String)body.get("className");
        this.id = (Number)body.get("ref");
        this.constructorRef = (Number)body.get("constructorFunction");
        this.prototypeRef = (Number)body.get("prototypeObject");
        List proplist = (List)body.get("properties");
        if (proplist != null) {
            this.properties = new ArrayList(proplist.size());
            Map props2 = null;
            for (Map props2 : proplist) {
                this.properties.add(new PropertyImpl(vm, frame, props2.get("name").toString(), (Number)props2.get("ref")));
            }
        } else {
            this.properties = NO_PROPERTIES;
        }
    }

    public String className() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value constructor() {
        StackFrameImpl stackFrameImpl = this.frame;
        synchronized (stackFrameImpl) {
            if (this.constructor == null) {
                this.constructor = this.frame.lookupValue(this.constructorRef);
                if (this.constructor == null) {
                    this.constructor = this.vm.mirrorOfNull();
                }
            }
        }
        return this.constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value prototype() {
        StackFrameImpl stackFrameImpl = this.frame;
        synchronized (stackFrameImpl) {
            if (this.prototype == null) {
                this.prototype = this.frame.lookupValue(this.prototypeRef);
                if (this.prototype == null) {
                    this.prototype = this.vm.mirrorOfNull();
                }
            }
        }
        return this.prototype;
    }

    public List properties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Object Reference\n");
        return buffer.toString();
    }

    public String valueString() {
        return "Object";
    }

    public Number id() {
        return this.id;
    }
}

