/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import junit.framework.TestCase;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.xml.core.internal.contenttype.XMLResourceEncodingDetector;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;

public class XMLMalformedInputTests
extends TestCase {
    private int READ_BUFFER_SIZE = 8000;
    private boolean DEBUG = false;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String specialSaveChars = "=: \t\r\n\f#!";

    public XMLMalformedInputTests(String name) {
        super(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doTestMalformedInput(String filename, IResourceCharsetDetector detector, int expectedPosition) throws IOException {
        FileInputStream inputStream;
        int badCharPosition;
        MalformedInputExceptionWithDetail foundException;
        block11: {
            foundException = null;
            badCharPosition = -1;
            File file = TestsPlugin.getTestFile(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.valueOf(filename) + " was not found");
            }
            inputStream = new FileInputStream(file);
            InputStream istream = XMLMalformedInputTests.getMarkSupportedStream(inputStream);
            detector.set(istream);
            EncodingMemento encodingMemento = ((XMLResourceEncodingDetector)detector).getEncodingMemento();
            String foundIANAEncoding = encodingMemento.getJavaCharsetName();
            Charset charset = Charset.forName(foundIANAEncoding);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            istream.close();
            ((InputStream)inputStream).close();
            inputStream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charsetDecoder);
            try {
                try {
                    this.readInputStream(reader);
                }
                catch (MalformedInputException malformedInputException) {
                    ((InputStream)inputStream).close();
                    istream.close();
                    inputStream = new FileInputStream(file);
                    charsetDecoder = charset.newDecoder();
                    charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
                    charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    reader = new InputStreamReader((InputStream)inputStream, charsetDecoder);
                    istream = XMLMalformedInputTests.getMarkSupportedStream(inputStream);
                    try {
                        this.handleMalFormedInput_DetailChecking(reader, foundIANAEncoding);
                    }
                    catch (MalformedInputExceptionWithDetail se) {
                        foundException = se;
                        badCharPosition = se.getCharPosition();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (istream != null) {
                    istream.close();
                }
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                throw throwable;
            }
            {
                Object var15_17 = null;
                if (istream == null) break block11;
            }
            istream.close();
        }
        if (inputStream != null) {
            ((InputStream)inputStream).close();
        }
        XMLMalformedInputTests.assertTrue((String)("MalformedInputException was not thrown as expected for filename: " + filename + " Exception thrown:" + foundException), (boolean)(foundException instanceof MalformedInputExceptionWithDetail));
        XMLMalformedInputTests.assertTrue((String)("Wrong character position detected in MalformedInputException.  Expected: " + expectedPosition + " Found: " + badCharPosition), (badCharPosition == expectedPosition || badCharPosition == expectedPosition - 2 ? 1 : 0) != 0);
    }

    private static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    private StringBuffer readInputStream(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        char[] tBuff = new char[this.READ_BUFFER_SIZE];
        while ((numRead = reader.read(tBuff, 0, tBuff.length)) != -1) {
            if (this.DEBUG) {
                System.out.println(tBuff[0]);
            }
            buffer.append(tBuff, 0, numRead);
        }
        return buffer;
    }

    public void testNoOp() {
        XMLMalformedInputTests.assertTrue((boolean)true);
    }

    private void handleMalFormedInput_DetailChecking(Reader reader, String encodingName) throws IOException, MalformedInputExceptionWithDetail {
        int charPostion = -1;
        charPostion = this.getCharPostionOfFailure(reader);
        throw new MalformedInputExceptionWithDetail(encodingName, charPostion);
    }

    private int getCharPostionOfFailure(Reader reader) throws IOException {
        int charPosition = 1;
        int charRead = -1;
        int result = -1;
        boolean errorFound = false;
        do {
            try {
                if (reader.ready()) {
                    charRead = reader.read();
                }
                if (this.DEBUG) {
                    System.out.println(String.valueOf(charPosition) + ": " + this.escape((char)charRead, true));
                }
                ++charPosition;
            }
            catch (MalformedInputException malformedInputException) {
                errorFound = true;
                break;
            }
        } while (charRead != -1 && !errorFound && reader.ready());
        result = errorFound ? charPosition : -1;
        return result;
    }

    private String escape(char aChar, boolean escapeSpace) {
        StringBuffer outBuffer = new StringBuffer();
        switch (aChar) {
            case ' ': {
                if (escapeSpace) {
                    outBuffer.append('\\');
                }
                outBuffer.append(' ');
                break;
            }
            case '\\': {
                outBuffer.append('\\');
                outBuffer.append('\\');
                break;
            }
            case '\t': {
                outBuffer.append('\\');
                outBuffer.append('t');
                break;
            }
            case '\n': {
                outBuffer.append('\\');
                outBuffer.append('n');
                break;
            }
            case '\r': {
                outBuffer.append('\\');
                outBuffer.append('r');
                break;
            }
            case '\f': {
                outBuffer.append('\\');
                outBuffer.append('f');
                break;
            }
            default: {
                if (aChar < ' ' || aChar > '~') {
                    outBuffer.append('\\');
                    outBuffer.append('u');
                    outBuffer.append(XMLMalformedInputTests.toHex(aChar >> 12 & 0xF));
                    outBuffer.append(XMLMalformedInputTests.toHex(aChar >> 8 & 0xF));
                    outBuffer.append(XMLMalformedInputTests.toHex(aChar >> 4 & 0xF));
                    outBuffer.append(XMLMalformedInputTests.toHex(aChar & 0xF));
                    break;
                }
                if (specialSaveChars.indexOf(aChar) != -1) {
                    outBuffer.append('\\');
                }
                outBuffer.append(aChar);
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

