/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.jaxb.core.internal.resource.jaxbprops.JaxbPropertiesResourceModelProvider;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;

public class JaxbPropertiesResourceTests
extends AnnotationTestCase {
    private static String JAXB_PROPERTIES = "jaxb.properties";

    public JaxbPropertiesResourceTests(String name) {
        super(name);
    }

    private IFile createJaxbProperties(IPath projectRelativePath, String[] ... propertyValuePairs) throws Exception {
        IFolder folder = this.getProject().getFolder(projectRelativePath);
        if (!folder.exists()) {
            folder.create(true, false, null);
        }
        IFile jaxbProperties = this.getProject().getFile(projectRelativePath.append((IPath)new Path(JAXB_PROPERTIES)));
        InputStream stream = this.inputStream(propertyValuePairs);
        jaxbProperties.create(stream, true, null);
        return jaxbProperties;
    }

    private void setProperties(IFile jaxbProperties, String[] ... propertyValuePairs) throws Exception {
        jaxbProperties.setContents(this.inputStream(propertyValuePairs), true, false, null);
    }

    private InputStream inputStream(String[] ... propertyValuePairs) {
        StringBuffer sb = new StringBuffer();
        String[][] stringArray = propertyValuePairs;
        int n = propertyValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] propertyValuePair = stringArray[n2];
            sb.append(String.valueOf(propertyValuePair[0]) + "=" + propertyValuePair[1] + CR);
            ++n2;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void testUpdateProperties() throws Exception {
        IFile jaxbProperties = this.createJaxbProperties((IPath)new Path("src/test"), {"foo", "fooProp"}, {"bar", "barProp"});
        JaxbPropertiesResource resource = JaxbPropertiesResourceModelProvider.instance().buildResourceModel(jaxbProperties);
        JaxbPropertiesResourceTests.assertEquals((String)resource.getProperty("foo"), (String)"fooProp");
        JaxbPropertiesResourceTests.assertEquals((String)resource.getProperty("bar"), (String)"barProp");
        this.setProperties(jaxbProperties, {"foo", "fooProp2"}, {"baz", "bazProp"});
        JaxbPropertiesResourceTests.assertEquals((String)resource.getProperty("foo"), (String)"fooProp2");
        JaxbPropertiesResourceTests.assertNull((Object)resource.getProperty("bar"));
        JaxbPropertiesResourceTests.assertEquals((String)resource.getProperty("baz"), (String)"bazProp");
        this.setProperties(jaxbProperties, new String[0][]);
        JaxbPropertiesResourceTests.assertNull((Object)resource.getProperty("foo"));
        JaxbPropertiesResourceTests.assertNull((Object)resource.getProperty("bar"));
        JaxbPropertiesResourceTests.assertNull((Object)resource.getProperty("baz"));
    }
}

