/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClassAnnotation2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumnAnnotation2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumeratedAnnotation2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporalAnnotation2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToManyAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaOneToManyMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0JavaOneToManyMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private AnnotationTestType employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private String address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityPropertyInfo() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(orphanRemoval=false)").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private OrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return oneToManyMapping.getOrphanRemoval();
    }

    public void testDefaultOneToManyGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToManyMapping).isDefaultOrphanRemoval());
    }

    public void testSpecifiedOneToManyGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToManyMapping).isDefaultOrphanRemoval());
    }

    public void testGetOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation2_0 oneToMany = (OneToManyAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToMany");
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testSetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation2_0 oneToMany = (OneToManyAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToMany.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
    }

    public void testSetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation2_0 oneToMany = (OneToManyAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToMany.getOrphanRemoval());
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
    }

    public void testGetSpecifiedOrphanRemovalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation2_0 oneToMany = (OneToManyAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToMany");
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        oneToMany.setOrphanRemoval(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0JavaOneToManyMappingTests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        resourceField.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        resourceField.addAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        resourceField.removeAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        oneToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        oneToManyMapping.setSpecifiedMapKey(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mapKey.getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = javaOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"employee", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = javaOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = javaOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"employee", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        resourceField.addAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        MapKeyClassAnnotation2_0 mapKeyClassAnnotation = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)mapKeyClassAnnotation);
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"myMapKeyClass", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"myMapKeyClass", (String)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        resourceField.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        oneToManyMapping.setSpecifiedMapKeyClass("String");
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"String", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        oneToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getDefaultMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        this.addXmlClassRef("test.PrintQueue");
        this.addXmlClassRef("test.PrintJob");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)this.getJavaPersistentType().getAttributeNamed("jobs").getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        SpecifiedOrderColumn2_0 orderColumn = orderable.getOrderColumn();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderColumn.getTableName());
        orderColumn.setSpecifiedName("FOO");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderColumn.getTableName());
        JavaPersistentType printJobPersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTableName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testGetMapKeyColumnMappedByStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.getRelationship().setStrategyToMappedBy();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("employee");
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("MY_PRIMARY_TABLE");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"MY_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumnAnnotation2_0 column = (MapKeyColumnAnnotation2_0)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnJoinTableStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_PRIMARY_TABLE");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"MY_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumnAnnotation2_0 column = (MapKeyColumnAnnotation2_0)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((SpecifiedJoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)((SpecifiedJoinColumnRelationship)oneToManyMapping.getRelationship()).getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"Address", (String)joinColumn.getDefaultTableName());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTableName());
        joinColumn.setSpecifiedName("FOO");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTableName());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((SpecifiedJoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumnAnnotation2_0 column = (MapKeyColumnAnnotation2_0)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTableName());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((SpecifiedJoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        ((Orderable2_0)oneToManyMapping.getOrderable()).setOrderColumnOrdering();
        SpecifiedOrderColumn2_0 orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"Address", (String)orderColumn.getTableName());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTableName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        SpecifiedPersistentAttribute contextAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 mapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OneToManyRelationship2_0 rel = (OneToManyRelationship2_0)mapping.getRelationship();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        SpecifiedPersistentAttribute contextAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 mapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OneToManyRelationship2_0 rel = (OneToManyRelationship2_0)mapping.getRelationship();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testMapKeySpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        this.addXmlClassRef("test.PropertyInfo");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BLAH", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BLAH", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BLAH", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BLAH", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"value.BAR", (String)((SpecifiedAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTableName("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTableName(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((SpecifiedAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((SpecifiedAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.foo", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.address", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ListIterator specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)((SpecifiedAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.foo", (String)((SpecifiedAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"state.foo", (String)((SpecifiedAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((String)"city", (String)((SpecifiedAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSetSpecifiedMapKeyEnumerated() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getConverterType());
        oneToManyMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumeratedAnnotation2_0 enumerated = (MapKeyEnumeratedAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)enumerated);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals(null, (Object)enumerated.getValue());
        ((BaseEnumeratedConverter)oneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((BaseEnumeratedConverter)oneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)enumerated.getValue());
        oneToManyMapping.setMapKeyConverter(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
    }

    public void testGetSpecifiedMapKeyEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getConverterType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumeratedAnnotation2_0 enumerated = (MapKeyEnumeratedAnnotation2_0)resourceField.addAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)oneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)((BaseEnumeratedConverter)oneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        EclipseLink2_0JavaOneToManyMappingTests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSetMapKeyTemporal() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getConverterType());
        oneToManyMapping.setMapKeyConverter(BaseTemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporalAnnotation2_0 temporal = (MapKeyTemporalAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)temporal);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals(null, (Object)temporal.getValue());
        ((BaseTemporalConverter)oneToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        ((BaseTemporalConverter)oneToManyMapping.getMapKeyConverter()).setTemporalType(null);
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
    }

    public void testGetMapKeyTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getConverterType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporalAnnotation2_0 temporal = (MapKeyTemporalAnnotation2_0)resourceField.addAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)oneToManyMapping.getMapKeyConverter()).getTemporalType());
        temporal.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
        EclipseLink2_0JavaOneToManyMappingTests.assertNull((Object)((BaseTemporalConverter)oneToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        EclipseLink2_0JavaOneToManyMappingTests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
    }
}

