/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class ConversionValueAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ConversionValueAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestObjectTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter");
            }
        });
    }

    private ICompilationUnit createTestObjectTypeConverterWithConversionValues() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter(conversionValues = {@ConversionValue(dataValue = \"F\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})");
            }
        });
    }

    public void testGetDataValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValueAnnotationTests.assertEquals((String)"F", (String)converter.conversionValueAt(0).getDataValue());
    }

    public void testSetDataValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValueAnnotationTests.assertEquals((String)"F", (String)converter.conversionValueAt(0).getDataValue());
        converter.conversionValueAt(0).setDataValue("FOO");
        ConversionValueAnnotationTests.assertEquals((String)"FOO", (String)converter.conversionValueAt(0).getDataValue());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(dataValue = \"FOO\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})", cu);
    }

    public void testSetDataValueNull() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValueAnnotationTests.assertEquals((int)0, (int)converter.getConversionValuesSize());
        converter.addConversionValue(0).setDataValue("FOO");
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = @ConversionValue(dataValue = \"FOO\"))", cu);
        converter.conversionValueAt(0).setDataValue(null);
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = @ConversionValue)", cu);
        ConversionValueAnnotationTests.assertEquals((int)1, (int)converter.getConversionValuesSize());
    }

    public void testGetObjectValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValueAnnotationTests.assertEquals((String)"Female", (String)converter.conversionValueAt(0).getObjectValue());
    }

    public void testSetObjectValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValueAnnotationTests.assertEquals((String)"Female", (String)converter.conversionValueAt(0).getObjectValue());
        converter.conversionValueAt(0).setObjectValue("FOO");
        ConversionValueAnnotationTests.assertEquals((String)"FOO", (String)converter.conversionValueAt(0).getObjectValue());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(dataValue = \"F\", objectValue = \"FOO\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})", cu);
    }

    public void testSetObjectValueNull() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValueAnnotationTests.assertEquals((int)0, (int)converter.getConversionValuesSize());
        converter.addConversionValue(0).setObjectValue("FOO");
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = @ConversionValue(objectValue = \"FOO\"))", cu);
        converter.conversionValueAt(0).setObjectValue(null);
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = @ConversionValue)", cu);
        ConversionValueAnnotationTests.assertEquals((int)1, (int)converter.getConversionValuesSize());
    }
}

