/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.TimeOfDayAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class TimeOfDayTests
extends EclipseLinkJavaResourceModelTestCase {
    public TimeOfDayTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTimeOfDay() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.TimeOfDay"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiryTimeOfDay = @TimeOfDay)");
            }
        });
    }

    private ICompilationUnit createTestTimeOfDayWithHour() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.TimeOfDay"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiryTimeOfDay = @TimeOfDay(hour=5))");
            }
        });
    }

    private ICompilationUnit createTestTimeOfDayWithMinute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.TimeOfDay"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiryTimeOfDay = @TimeOfDay(minute=5))");
            }
        });
    }

    private ICompilationUnit createTestTimeOfDayWithSecond() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.TimeOfDay"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiryTimeOfDay = @TimeOfDay(second=5))");
            }
        });
    }

    private ICompilationUnit createTestTimeOfDayWithMillisecond() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.TimeOfDay"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiryTimeOfDay = @TimeOfDay(millisecond=5))");
            }
        });
    }

    public void testExpiryTimeOfDay() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDay();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertNotNull((Object)timeOfDay);
    }

    public void testGetHour() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithHour();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getHour());
    }

    public void testSetHour() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithHour();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getHour());
        timeOfDay.setHour(Integer.valueOf(80));
        TimeOfDayTests.assertEquals((Object)80, (Object)timeOfDay.getHour());
        this.assertSourceContains("@TimeOfDay(hour=80)", cu);
        timeOfDay.setHour(null);
        TimeOfDayTests.assertNull((Object)timeOfDay.getHour());
        this.assertSourceDoesNotContain("(hour=80)", cu);
        this.assertSourceContains("@TimeOfDay", cu);
    }

    public void testGetMinute() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithMinute();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getMinute());
    }

    public void testSetMinute() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithMinute();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getMinute());
        timeOfDay.setMinute(Integer.valueOf(80));
        TimeOfDayTests.assertEquals((Object)80, (Object)timeOfDay.getMinute());
        this.assertSourceContains("@TimeOfDay(minute=80)", cu);
        timeOfDay.setMinute(null);
        TimeOfDayTests.assertNull((Object)timeOfDay.getMinute());
        this.assertSourceDoesNotContain("(minute=80)", cu);
        this.assertSourceContains("@TimeOfDay", cu);
    }

    public void testGetSecond() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithSecond();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getSecond());
    }

    public void testSetSecond() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithSecond();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getSecond());
        timeOfDay.setSecond(Integer.valueOf(80));
        TimeOfDayTests.assertEquals((Object)80, (Object)timeOfDay.getSecond());
        this.assertSourceContains("@TimeOfDay(second=80)", cu);
        timeOfDay.setSecond(null);
        TimeOfDayTests.assertNull((Object)timeOfDay.getSecond());
        this.assertSourceDoesNotContain("(second=80)", cu);
        this.assertSourceContains("@TimeOfDay", cu);
    }

    public void testGetMillisecond() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithMillisecond();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getMillisecond());
    }

    public void testSetMillisecond() throws Exception {
        ICompilationUnit cu = this.createTestTimeOfDayWithMillisecond();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheAnnotation cache = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        TimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        TimeOfDayTests.assertEquals((Object)5, (Object)timeOfDay.getMillisecond());
        timeOfDay.setMillisecond(Integer.valueOf(80));
        TimeOfDayTests.assertEquals((Object)80, (Object)timeOfDay.getMillisecond());
        this.assertSourceContains("@TimeOfDay(millisecond=80)", cu);
        timeOfDay.setMillisecond(null);
        TimeOfDayTests.assertNull((Object)timeOfDay.getMillisecond());
        this.assertSourceDoesNotContain("(millisecond=80)", cu);
        this.assertSourceContains("@TimeOfDay", cu);
    }
}

