/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAdapter;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlAdapterTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlAdapterTests(String name) {
        super(name);
    }

    private ICompilationUnit createXmlType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }
        });
    }

    private void createObjObjXmlAdapter() throws CoreException {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import javax.xml.bind.annotation.adapters.XmlAdapter;").append(CR);
                sb.append(CR);
                sb.append("public class ObjObjAdapter extends XmlAdapter<Object, Object> {").append(CR);
                sb.append("    public Object marshal(Object obj) { return null; }").append(CR);
                sb.append("    public Object unmarshal(Object obj) { return null; }").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "ObjObjAdapter.java", sourceWriter);
    }

    private void createMapCalendarXmlAdapter() throws CoreException {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import javax.xml.bind.annotation.adapters.XmlAdapter;").append(CR);
                sb.append("import java.util.Map;").append(CR);
                sb.append("import java.util.GregorianCalendar;").append(CR);
                sb.append(CR);
                sb.append("public class MapCalendarAdapter extends XmlAdapter<GregorianCalendar, Map<String, String>> {").append(CR);
                sb.append("    public GregorianCalendar marshal(Map<String, String> obj) { return null; }").append(CR);
                sb.append("    public GregorianCalendar marshal(Object obj) { return null; }").append(CR);
                sb.append("    public Map<String, String> unmarshal(Gregorian Calendar obj) { return null; }").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "MapCalendarAdapter.java", sourceWriter);
    }

    public void testBoundAndValueTypes() throws Exception {
        this.createXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping attributeMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlJavaTypeAdapter xmlJavaTypeAdapter = attributeMapping.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapter.setValue("test.ObjObjAdapter");
        GenericJavaXmlAdapterTests.assertEquals((String)"test.ObjObjAdapter", (String)xmlJavaTypeAdapter.getValue());
        GenericJavaXmlAdapterTests.assertEquals((String)"test.ObjObjAdapter", (String)xmlJavaTypeAdapter.getFullyQualifiedValue());
        GenericJavaXmlAdapterTests.assertNull((Object)xmlJavaTypeAdapter.getXmlAdapter());
        this.createObjObjXmlAdapter();
        XmlAdapter xmlAdapter = xmlJavaTypeAdapter.getXmlAdapter();
        GenericJavaXmlAdapterTests.assertNotNull((Object)xmlAdapter);
        GenericJavaXmlAdapterTests.assertEquals((String)"java.lang.Object", (String)xmlAdapter.getBoundType());
        GenericJavaXmlAdapterTests.assertEquals((String)"java.lang.Object", (String)xmlAdapter.getValueType());
        this.createMapCalendarXmlAdapter();
        xmlJavaTypeAdapter.setValue("test.MapCalendarAdapter");
        xmlAdapter = xmlJavaTypeAdapter.getXmlAdapter();
        GenericJavaXmlAdapterTests.assertNotNull((Object)xmlAdapter);
        GenericJavaXmlAdapterTests.assertEquals((String)"java.util.Map", (String)xmlAdapter.getBoundType());
        GenericJavaXmlAdapterTests.assertEquals((String)"java.util.GregorianCalendar", (String)xmlAdapter.getValueType());
    }
}

