/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.internal.resource.jaxbindex.JaxbIndexResourceModelProvider;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;

public class JaxbIndexResourceTests
extends AnnotationTestCase {
    private static String JAXB_INDEX = "jaxb.index";

    public JaxbIndexResourceTests(String name) {
        super(name);
    }

    private IFile createJaxbIndex(IPath projectRelativePath, String ... classNames) throws Exception {
        IFolder folder = this.getProject().getFolder(projectRelativePath);
        if (!folder.exists()) {
            folder.create(true, false, null);
        }
        IFile jaxbIndex = this.getProject().getFile(projectRelativePath.append((IPath)new Path(JAXB_INDEX)));
        InputStream stream = this.inputStream(classNames);
        jaxbIndex.create(stream, true, null);
        return jaxbIndex;
    }

    private void setClassNames(IFile jaxbIndex, String ... classNames) throws Exception {
        jaxbIndex.setContents(this.inputStream(classNames), true, false, null);
    }

    private InputStream inputStream(String ... classNames) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            sb.append(String.valueOf(className) + CR);
            ++n2;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void testUpdateClasses() throws Exception {
        IFile jaxbIndex = this.createJaxbIndex((IPath)new Path("src/test"), "foo", "bar");
        JaxbIndexResource resource = JaxbIndexResourceModelProvider.instance().buildResourceModel(jaxbIndex);
        JaxbIndexResourceTests.assertTrue((boolean)IterableTools.elementsAreEqual((Iterable)resource.getFullyQualifiedClassNames(), (Iterable)IterableTools.iterable((Object[])new String[]{"test.foo", "test.bar"})));
        this.setClassNames(jaxbIndex, "foo", "bar", "baz");
        JaxbIndexResourceTests.assertTrue((boolean)IterableTools.elementsAreEqual((Iterable)resource.getFullyQualifiedClassNames(), (Iterable)IterableTools.iterable((Object[])new String[]{"test.foo", "test.bar", "test.baz"})));
        this.setClassNames(jaxbIndex, new String[0]);
        JaxbIndexResourceTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)resource.getFullyQualifiedClassNames()));
        jaxbIndex = this.createJaxbIndex((IPath)new Path("src"), "foo", "bar");
        resource = JaxbIndexResourceModelProvider.instance().buildResourceModel(jaxbIndex);
        JaxbIndexResourceTests.assertTrue((boolean)IterableTools.elementsAreEqual((Iterable)resource.getFullyQualifiedClassNames(), (Iterable)IterableTools.iterable((Object[])new String[]{"foo", "bar"})));
        this.setClassNames(jaxbIndex, "foo", "bar", "baz");
        JaxbIndexResourceTests.assertTrue((boolean)IterableTools.elementsAreEqual((Iterable)resource.getFullyQualifiedClassNames(), (Iterable)IterableTools.iterable((Object[])new String[]{"foo", "bar", "baz"})));
        this.setClassNames(jaxbIndex, new String[0]);
        JaxbIndexResourceTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)resource.getFullyQualifiedClassNames()));
    }
}

