/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaJoinColumnTests
extends ContextModelTestCase {
    public JavaJoinColumnTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithOneToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
                sb.append("    private Project project;").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnAnnotation joinColumnAnnotation = (JoinColumnAnnotation)resourceField.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)joinColumnAnnotation);
        joinColumnAnnotation = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        joinColumnAnnotation.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        JavaJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnAnnotation.getName());
        joinColumn.setSpecifiedName(null);
        JavaJoinColumnTests.assertEquals((int)1, (int)joinColumns.getSpecifiedJoinColumnsSize());
        joinColumnAnnotation = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertNull((Object)joinColumnAnnotation.getName());
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        JoinColumnAnnotation joinColumnAnnotation = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((String)"foo", (String)joinColumn.getSpecifiedName());
        JavaJoinColumnTests.assertEquals((String)"foo", (String)joinColumnAnnotation.getName());
        joinColumn.setSpecifiedName(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedName());
        joinColumnAnnotation = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertNull((Object)joinColumnAnnotation.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidOneToOne();
        this.createTargetEntity();
        this.addXmlClassRef("test.AnnotationTestType");
    }

    public void testUpdateSpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setReferencedColumnName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getReferencedColumnName());
        javaJoinColumn.setReferencedColumnName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertNull((String)"BAR", (Object)javaJoinColumn.getReferencedColumnName());
    }

    public void testModifySpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedReferencedColumnName("BAR");
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getReferencedColumnName());
        joinColumn.setSpecifiedReferencedColumnName(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getReferencedColumnName());
    }

    public void testDefaultReferencedColumnName() throws Exception {
    }

    public void testUpdateTable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setTable("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedTableName());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getTable());
        javaJoinColumn.setTable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedTableName());
        JavaJoinColumnTests.assertNull((String)"BAR", (Object)javaJoinColumn.getTable());
    }

    public void testModifyTable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedTableName("BAR");
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedTableName());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getTable());
        joinColumn.setSpecifiedTableName(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedTableName());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getTable());
    }

    public void testDefaultTable() throws Exception {
    }

    public void testUpdateUnique() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setUnique(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)javaJoinColumn.getUnique());
        javaJoinColumn.setUnique(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUnique());
    }

    public void testModifyUnique() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)javaJoinColumn.getUnique());
        joinColumn.setSpecifiedUnique(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUnique());
    }

    public void testUpdateNullable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setNullable(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getNullable());
        javaJoinColumn.setNullable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getNullable());
    }

    public void testModifyNullable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getNullable());
        joinColumn.setSpecifiedNullable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getNullable());
    }

    public void testUpdateInsertable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setInsertable(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getInsertable());
        javaJoinColumn.setInsertable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getInsertable());
    }

    public void testModifyInsertable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getInsertable());
        joinColumn.setSpecifiedInsertable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getInsertable());
    }

    public void testUpdateUpdatable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinColumnTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        JavaJoinColumnTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setUpdatable(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaSpecifiedJoinColumn joinColumn = (JavaSpecifiedJoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getUpdatable());
        javaJoinColumn.setUpdatable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUpdatable());
    }

    public void testModifyUpdatable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinColumns.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getUpdatable());
        joinColumn.setSpecifiedUpdatable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUpdatable());
    }
}

