/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.Orderable;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToManyRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmOneToManyMappingTests
extends ContextModelTestCase {
    public OrmOneToManyMappingTests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithOneToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)oneToMany.getName());
        oneToMany.setName("newName");
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)oneToMany.getName());
        oneToMany.setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)oneToMany.getName());
        ormOneToManyMapping.setName("newName");
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)oneToMany.getName());
        ormOneToManyMapping.setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity("newTargetEntity");
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        ormOneToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        ormOneToManyMapping.setSpecifiedTargetEntity(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        ormOneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        ormOneToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getSpecifiedFetch());
        ormOneToManyMapping.setSpecifiedFetch(null);
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedMappedByRelationshipStrategy strategy = ormOneToManyMapping.getRelationship().getMappedByStrategy();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        oneToMany.setMappedBy("newMappedBy");
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        oneToMany.setMappedBy(null);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedMappedByRelationshipStrategy strategy = ormOneToManyMapping.getRelationship().getMappedByStrategy();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToManyMapping contextMapping = (OrmOneToManyMapping)contextAttribute.getMapping();
        OrmOneToManyRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToManyMapping contextMapping = (OrmOneToManyMapping)contextAttribute.getMapping();
        OrmOneToManyRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
        oneToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getMapKey());
        oneToMany.getMapKey().setName("myMapKey");
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName("myMapKey");
        oneToMany.setMapKey(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isPkMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isCustomMapKey());
        OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)virtualOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isPkMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isCustomMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isPkMapKey());
        OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isCustomMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
        ormOneToManyMapping.setSpecifiedMapKey("myMapKey");
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        ormOneToManyMapping.setNoMapKey(true);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateOrderBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        Orderable orderable = ormOneToManyMapping.getOrderable();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isOrderByOrdering());
        OrmOneToManyMappingTests.assertNull((Object)orderable.getOrderBy().getKey());
        oneToMany.setOrderBy(OrmFactory.eINSTANCE.createXmlOrderBy());
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getOrderBy());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isOrderByOrdering());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.getOrderBy().isByPrimaryKey());
        OrmOneToManyMappingTests.assertTrue((boolean)StringTools.isBlank((String)orderable.getOrderBy().getKey()));
        oneToMany.getOrderBy().setValue("foo");
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getOrderBy().getValue());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isOrderByOrdering());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.getOrderBy().isByPrimaryKey());
        OrmOneToManyMappingTests.assertEquals((String)"foo", (String)orderable.getOrderBy().getKey());
        oneToMany.setOrderBy(null);
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isOrderByOrdering());
    }

    public void testModifyOrderBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        Orderable orderable = ormOneToManyMapping.getOrderable();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isOrderByOrdering());
        OrmOneToManyMappingTests.assertNull((Object)orderable.getOrderBy().getKey());
        orderable.setOrderByOrdering();
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getOrderBy());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isOrderByOrdering());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.getOrderBy().isByPrimaryKey());
        OrmOneToManyMappingTests.assertTrue((boolean)StringTools.isBlank((String)orderable.getOrderBy().getKey()));
        orderable.getOrderBy().setKey("foo");
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getOrderBy().getValue());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isOrderByOrdering());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.getOrderBy().isByPrimaryKey());
        OrmOneToManyMappingTests.assertEquals((String)"foo", (String)orderable.getOrderBy().getKey());
        orderable.setNoOrdering();
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        OrmOneToManyMappingTests.assertTrue((boolean)orderable.isNoOrdering());
        OrmOneToManyMappingTests.assertFalse((boolean)orderable.isOrderByOrdering());
    }

    public void testOneToManyMorphToIdMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToVersionMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        SpecifiedJoinColumn joinColumn = oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        SpecifiedJoinColumn inverseJoinColumn = oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToTransientMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToEmbeddedMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        SpecifiedJoinColumn joinColumn = oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        SpecifiedJoinColumn inverseJoinColumn = oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToEmbeddedIdMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToOneToOneMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"mappedBy", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToManyMorphToManyToManyMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        SpecifiedJoinColumn joinColumn = oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        SpecifiedJoinColumn inverseJoinColumn = oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        SpecifiedJoinTable joinTable = ((ManyToManyMapping)ormPersistentAttribute.getMapping()).getRelationship().getJoinTableStrategy().getJoinTable();
        OrmOneToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        OrmOneToManyMappingTests.assertEquals((String)"name", (String)((SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next()).getSpecifiedName());
        OrmOneToManyMappingTests.assertEquals((String)"referenceName", (String)((SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next()).getSpecifiedReferencedColumnName());
        OrmOneToManyMappingTests.assertEquals((String)"inverseName", (String)((SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next()).getSpecifiedName());
        OrmOneToManyMappingTests.assertEquals((String)"inverseReferenceName", (String)((SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next()).getSpecifiedReferencedColumnName());
    }

    public void testOneToManyMorphToManyToOneMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToManyMorphToBasicMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setOrderByOrdering();
        oneToManyMapping.getOrderable().getOrderBy().setKey("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        OrmOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        OrmOneToManyMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualOneToManyMapping.getCandidateMapKeyNames().iterator();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmPersistentAttribute virtualAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)virtualAttribute.getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualOneToManyMapping.getCandidateMapKeyNames().iterator();
        OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = virtualOneToManyMapping.getCandidateMapKeyNames().iterator();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        OrmOneToManyMapping specifiedOneToManyMapping = (OrmOneToManyMapping)virtualAttribute.addToXml().getMapping();
        mapKeyNames = specifiedOneToManyMapping.getCandidateMapKeyNames().iterator();
        OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        specifiedOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = specifiedOneToManyMapping.getCandidateMapKeyNames().iterator();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        specifiedOneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = specifiedOneToManyMapping.getCandidateMapKeyNames().iterator();
        OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)virtualPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)virtualOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"Address", (String)virtualOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade cascade = virtualOneToManyMapping.getCascade();
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isOrderByOrdering());
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getOrderable().getOrderBy().getKey());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmOneToManyMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        OrmOneToManyMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = virtualPersistentAttribute.addToXml("oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertEquals((String)"address", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getFetch());
        OrmOneToManyMappingTests.assertEquals((String)"test.Address", (String)ormOneToManyMapping.getTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmCascade cascade = ormOneToManyMapping.getCascade();
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        OrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getOrderable().getOrderBy().getKey());
    }
}

