/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmTableGeneratorTests
extends ContextModelTestCase {
    public OrmTableGeneratorTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getName());
        tableGeneratorResource.setName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getName());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getName());
        tableGenerator.setName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getName());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getName());
    }

    public void testUpdateSpecifiedInitialValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setInitialValue(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getInitialValue());
        tableGeneratorResource.setInitialValue(Integer.valueOf(1));
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGenerator.getSpecifiedInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGeneratorResource.getInitialValue());
        tableGeneratorResource.setInitialValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedInitialValue());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getInitialValue());
    }

    public void testModifySpecifiedInitialValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedInitialValue(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedInitialValue());
        tableGenerator.setSpecifiedInitialValue(Integer.valueOf(1));
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGeneratorResource.getInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGenerator.getSpecifiedInitialValue());
        tableGenerator.setSpecifiedInitialValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getInitialValue());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedInitialValue());
    }

    public void testUpdateSpecifiedAllocationSize() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setAllocationSize(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getAllocationSize());
        tableGeneratorResource.setAllocationSize(Integer.valueOf(1));
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGenerator.getSpecifiedAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGeneratorResource.getAllocationSize());
        tableGeneratorResource.setAllocationSize(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedAllocationSize());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getAllocationSize());
    }

    public void testModifySpecifiedAllocationSize() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedAllocationSize(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedAllocationSize());
        tableGenerator.setSpecifiedAllocationSize(Integer.valueOf(50));
        OrmTableGeneratorTests.assertEquals((Object)50, (Object)tableGeneratorResource.getAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)50, (Object)tableGenerator.getSpecifiedAllocationSize());
        tableGenerator.setSpecifiedAllocationSize(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getAllocationSize());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedAllocationSize());
    }

    public void testUpdateSpecifiedTableName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setTable("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedTableName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getTable());
        tableGeneratorResource.setTable(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedTableName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getTable());
    }

    public void testModifySpecifiedTableName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedTableName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getTable());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedTableName());
        tableGenerator.setSpecifiedTableName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getTable());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedTableName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setSchema("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedSchema());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getSchema());
        tableGeneratorResource.setSchema(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedSchema());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getSchema());
    }

    public void testModifySpecifiedSchema() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedSchema("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getSchema());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedSchema());
        tableGenerator.setSpecifiedSchema(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getSchema());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)tableGenerator.getDefaultSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setCatalog("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedCatalog());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getCatalog());
        tableGeneratorResource.setCatalog(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedCatalog());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getCatalog());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedCatalog("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getCatalog());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedCatalog());
        tableGenerator.setSpecifiedCatalog(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getCatalog());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedCatalog());
    }

    public void testUpdateSpecifiedPkColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setPkColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnName());
        tableGeneratorResource.setPkColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnName());
    }

    public void testModifySpecifiedPkColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedPkColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnName());
        tableGenerator.setSpecifiedPkColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnName());
    }

    public void testUpdateSpecifiedValueColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setValueColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedValueColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getValueColumnName());
        tableGeneratorResource.setValueColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedValueColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getValueColumnName());
    }

    public void testModifySpecifiedValueColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedValueColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getValueColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedValueColumnName());
        tableGenerator.setSpecifiedValueColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getValueColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedValueColumnName());
    }

    public void testUpdateSpecifiedPkColumnValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setPkColumnValue("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnValue());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnValue());
        tableGeneratorResource.setPkColumnValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnValue());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnValue());
    }

    public void testModifySpecifiedPkColumnValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedPkColumnValue("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnValue());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnValue());
        tableGenerator.setSpecifiedPkColumnValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnValue());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnValue());
    }

    public void testUniqueConstraints() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmTableGeneratorTests.assertEquals((String)"bar", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"foo", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        OrmTableGeneratorTests.assertEquals((int)0, (int)tableGenerator.getUniqueConstraintsSize());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        OrmTableGeneratorTests.assertEquals((int)2, (int)tableGenerator.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorResource.getUniqueConstraints().size());
        tableGenerator.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(1);
        uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(0);
        uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorResource.getUniqueConstraints().size());
        tableGenerator.moveUniqueConstraint(2, 0);
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        tableGenerator.moveUniqueConstraint(0, 1);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().move(2, 0);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().move(0, 1);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().remove(1);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().remove(1);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().remove(0);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsFromJava() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        IdMapping virtualIdMapping = (IdMapping)virtualAttribute.getMapping();
        JavaIdMapping javaIdMapping = (JavaIdMapping)((JavaSpecifiedPersistentAttribute)ormPersistentType.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaTableGenerator javaTableGenerator = javaIdMapping.getGeneratorContainer().addTableGenerator();
        javaTableGenerator.setName("TABLE_GENERATOR");
        TableGenerator tableGenerator = virtualIdMapping.getGeneratorContainer().getTableGenerator();
        OrmTableGeneratorTests.assertNull((Object)tableGenerator);
        javaTableGenerator.addUniqueConstraint().addColumnName("FOO");
        javaTableGenerator.addUniqueConstraint().addColumnName("BAR");
        javaTableGenerator.addUniqueConstraint().addColumnName("BAZ");
        OrmTableGeneratorTests.assertNull((Object)tableGenerator);
        OrmIdMapping ormIdMapping = (OrmIdMapping)virtualAttribute.addToXml().getMapping();
        OrmTableGenerator ormTableGenerator2 = ormIdMapping.getGeneratorContainer().addTableGenerator();
        ormTableGenerator2.setName("TABLE_GENERATOR");
        OrmTableGeneratorTests.assertEquals((int)0, (int)ormTableGenerator2.getUniqueConstraintsSize());
    }
}

