/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.CacheableAnnotation2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class Cacheable2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public Cacheable2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestCacheable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Cacheable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cacheable");
            }
        });
    }

    private ICompilationUnit createTestCacheableWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Cacheable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cacheable(value=true)");
            }
        });
    }

    public void testCacheableAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestCacheable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        Cacheable2_0AnnotationTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Cacheable"));
        resourceType.removeAnnotation("javax.persistence.Cacheable");
        Cacheable2_0AnnotationTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Cacheable"));
        resourceType.addAnnotation("javax.persistence.Cacheable");
        Cacheable2_0AnnotationTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Cacheable"));
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestCacheableWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)resourceType.getAnnotation("javax.persistence.Cacheable");
        Cacheable2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestCacheableWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)resourceType.getAnnotation("javax.persistence.Cacheable");
        Cacheable2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
        cacheableAnnotation.setValue(Boolean.FALSE);
        Cacheable2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(value=false)", cu);
        cacheableAnnotation.setValue(null);
        cacheableAnnotation.setValue(Boolean.FALSE);
        this.assertSourceContains("@Cacheable(false)", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestCacheableWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)resourceType.getAnnotation("javax.persistence.Cacheable");
        Cacheable2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
        cacheableAnnotation.setValue(null);
        Cacheable2_0AnnotationTests.assertNull((Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        this.assertSourceDoesNotContain("value", cu);
    }
}

