/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ElementCollectionAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class ElementCollection2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public ElementCollection2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestElementCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ElementCollection"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection");
            }
        });
    }

    private ICompilationUnit createTestElementCollectionWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ElementCollection", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection(fetch = FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestElementCollectionWithTargetClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ElementCollection"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection(targetClass = AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestElementCollectionWithPrimitiveTargetClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ElementCollection"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection(targetClass = byte.class)");
            }
        });
    }

    public void testElementCollection() throws Exception {
        ICompilationUnit cu = this.createTestElementCollection();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertNotNull((Object)elementCollection);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollection.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(FetchType.LAZY);
        ElementCollection2_0AnnotationTests.assertEquals((Object)FetchType.LAZY, (Object)elementCollection.getFetch());
        this.assertSourceContains("@ElementCollection(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(null);
        ElementCollection2_0AnnotationTests.assertNull((Object)elementCollection.getFetch());
        this.assertSourceContains("@ElementCollection", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetClass() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithTargetClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)elementCollection.getTargetClass());
    }

    public void testSetTargetClass() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithTargetClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)elementCollection.getTargetClass());
        elementCollection.setTargetClass("Foo");
        this.assertSourceContains("@ElementCollection(targetClass = Foo.class)", cu);
    }

    public void testSetTargetClassNull() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithTargetClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)elementCollection.getTargetClass());
        elementCollection.setTargetClass(null);
        this.assertSourceContains("@ElementCollection", cu);
        this.assertSourceDoesNotContain("targetClass", cu);
    }

    public void testGetFullyQualifiedTargetClass() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithTargetClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)elementCollection.getFullyQualifiedTargetClassName());
        elementCollection.setTargetClass("Foo");
        this.assertSourceContains("@ElementCollection(targetClass = Foo.class)", cu);
        ElementCollection2_0AnnotationTests.assertEquals((String)"Foo", (String)elementCollection.getTargetClass());
        ElementCollection2_0AnnotationTests.assertEquals((String)"Foo", (String)elementCollection.getFullyQualifiedTargetClassName());
    }

    public void testGetPrimitiveTargetClass() throws Exception {
        ICompilationUnit cu = this.createTestElementCollectionWithPrimitiveTargetClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals((String)"byte", (String)elementCollection.getTargetClass());
    }

    public void testSetPrimitiveTargetClass() throws Exception {
        ICompilationUnit cu = this.createTestElementCollection();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ElementCollectionAnnotation2_0 elementCollection = (ElementCollectionAnnotation2_0)resourceField.getAnnotation("javax.persistence.ElementCollection");
        ElementCollection2_0AnnotationTests.assertEquals(null, (String)elementCollection.getTargetClass());
        elementCollection.setTargetClass("int");
        this.assertSourceContains("@ElementCollection(targetClass = int.class)", cu);
    }
}

