/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.perf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleMapSourceFactory;
import org.eclipse.jst.jsf.test.util.PerfTracker;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.jst.jsf.validation.el.tests.base.JSPTestCase;

public class PropertyFileStressTest
extends JSPTestCase {
    private IFile _propertiesFile;

    public PropertyFileStressTest() {
        super(JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestFileResource resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/stress1.properties.data");
        this._propertiesFile = this._jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "res", "stress1.properties");
        PropertyFileStressTest.assertTrue((boolean)this._propertiesFile.isAccessible());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSanity() throws RuntimeException {
        Map resourceBundleMapSource;
        super.testSanity();
        try {
            resourceBundleMapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._testEnv.getTestProject(), (String)"res.stress1");
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        PropertyFileStressTest.assertEquals((int)8687, (int)resourceBundleMapSource.size());
    }

    public void testMapDescriptor_GetProperties() throws JavaModelException, IOException, CoreException {
        PerfTracker perfTracker = new PerfTracker("testMapDescriptor_GetProperties", 1000);
        int i = 0;
        while (i < 1000) {
            Map mapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._testEnv.getTestProject(), (String)"res.stress1");
            IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
            typeDesc.setMapSource(mapSource);
            long startTime = System.nanoTime();
            typeDesc.getProperties();
            perfTracker.recordTime(System.nanoTime() - startTime);
            ++i;
        }
        perfTracker.printReport(System.out);
    }

    public void testResourceMapSourceFactory() throws JavaModelException, IOException, CoreException {
        PerfTracker perfTracker = new PerfTracker("testResourceMapSourceFactory", 1000);
        int i = 0;
        while (i < 1000) {
            long startTime = System.nanoTime();
            ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._testEnv.getTestProject(), (String)"res.stress1");
            perfTracker.recordTime(System.nanoTime() - startTime);
            ++i;
        }
        perfTracker.printReport(System.out);
    }

    public void testResourceMapSource_GetEntrySet() throws JavaModelException, IOException, CoreException {
        PerfTracker perfTracker = new PerfTracker("testResourceMapSource_GetEntrySet", 1000);
        int i = 0;
        while (i < 1000) {
            Map resourceBundleMapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._testEnv.getTestProject(), (String)"res.stress1");
            long startTime = System.nanoTime();
            resourceBundleMapSource.entrySet();
            perfTracker.recordTime(System.nanoTime() - startTime);
            ++i;
        }
        perfTracker.printReport(System.out);
    }
}

