/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ManyToManyAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.resource.java.ManyToManyAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class ManyToMany2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public ManyToMany2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(fetch = FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithTargetEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(targetEntity = AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithMappedBy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(mappedBy = \"foo\")");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(cascade = CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithMultipleCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(cascade = {CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithDuplicateCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(cascade = {CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testManyToMany() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertNotNull((Object)manyToMany);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToMany.setFetch(FetchType.LAZY);
        ManyToMany2_0AnnotationTests.assertEquals((Object)FetchType.LAZY, (Object)manyToMany.getFetch());
        this.assertSourceContains("@ManyToMany(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToMany.setFetch(null);
        ManyToMany2_0AnnotationTests.assertNull((Object)manyToMany.getFetch());
        this.assertSourceContains("@ManyToMany", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)manyToMany.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToMany(targetEntity = Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity(null);
        this.assertSourceContains("@ManyToMany", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)manyToMany.getFullyQualifiedTargetEntityClassName());
        manyToMany.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToMany(targetEntity = Foo.class)", cu);
        ManyToMany2_0AnnotationTests.assertEquals((String)"Foo", (String)manyToMany.getTargetEntity());
        ManyToMany2_0AnnotationTests.assertEquals((String)"Foo", (String)manyToMany.getFullyQualifiedTargetEntityClassName());
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((String)"foo", (String)manyToMany.getMappedBy());
    }

    public void testGetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals(null, (String)manyToMany.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("bar");
        ManyToMany2_0AnnotationTests.assertEquals((String)"bar", (String)manyToMany.getMappedBy());
        this.assertSourceContains("@ManyToMany(mappedBy = \"bar\")", cu);
    }

    public void testSetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertEquals((String)"foo", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        ManyToMany2_0AnnotationTests.assertNull((Object)manyToMany.getMappedBy());
        this.assertSourceContains("@ManyToMany", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeAll());
        manyToMany.setCascadeAll(true);
        this.assertSourceContains("@ManyToMany(cascade = ALL)", cu);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeMerge());
        manyToMany.setCascadeMerge(true);
        this.assertSourceContains("@ManyToMany(cascade = MERGE)", cu);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadePersist());
        manyToMany.setCascadePersist(true);
        this.assertSourceContains("@ManyToMany(cascade = PERSIST)", cu);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeRemove());
        manyToMany.setCascadeRemove(true);
        this.assertSourceContains("@ManyToMany(cascade = REMOVE)", cu);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeRefresh());
        manyToMany.setCascadeRefresh(true);
        this.assertSourceContains("@ManyToMany(cascade = REFRESH)", cu);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeRefresh());
    }

    public void testSetCascadeDetach() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation2_0 manyToMany = (ManyToManyAnnotation2_0)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeDetach());
        manyToMany.setCascadeDetach(true);
        this.assertSourceContains("@ManyToMany(cascade = DETACH)", cu);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeDetach());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeAll());
        manyToMany.setCascadeAll(true);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeAll());
        this.assertSourceContains("@ManyToMany(cascade = CascadeType.ALL)", cu);
        manyToMany.setCascadeAll(false);
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        manyToMany.setCascadeAll(false);
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithDuplicateCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeMerge());
        manyToMany.setCascadeMerge(false);
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeMerge());
        manyToMany.setCascadeMerge(false);
        ManyToMany2_0AnnotationTests.assertFalse((boolean)manyToMany.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithMultipleCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)resourceField.getAnnotation("javax.persistence.ManyToMany");
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeMerge());
        ManyToMany2_0AnnotationTests.assertTrue((boolean)manyToMany.isCascadeRemove());
        manyToMany.setCascadeMerge(false);
        this.assertSourceContains("@ManyToMany(cascade = REMOVE)", cu);
        manyToMany.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

