/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OrderColumnAnnotation2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class OrderColumn2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";

    public OrderColumn2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOrderColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OrderColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderColumn");
            }
        });
    }

    private ICompilationUnit createTestOrderColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OrderColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestOrderColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OrderColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestOrderColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OrderColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderColumn(" + booleanElement + " = true)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getName());
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getNullable());
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getInsertable());
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getName());
        column.setName("Foo");
        OrderColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@OrderColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getName());
        column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        this.assertSourceContains("@OrderColumn", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        OrderColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@OrderColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        this.assertSourceContains("@OrderColumn", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumnWithBooleanElement("nullable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        OrderColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        this.assertSourceContains("@OrderColumn(nullable = false)", cu);
        column.setNullable(null);
        column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        this.assertSourceContains("@OrderColumn", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumnWithBooleanElement("insertable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        OrderColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        this.assertSourceContains("@OrderColumn(insertable = false)", cu);
        column.setInsertable(null);
        column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        this.assertSourceContains("@OrderColumn", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumnWithBooleanElement("updatable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestOrderColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderColumnAnnotation2_0 column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        OrderColumn2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        OrderColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        this.assertSourceContains("@OrderColumn(updatable = false)", cu);
        column.setUpdatable(null);
        column = (OrderColumnAnnotation2_0)resourceField.getAnnotation("javax.persistence.OrderColumn");
        OrderColumn2_0AnnotationTests.assertNotNull((Object)column);
        this.assertSourceContains("@OrderColumn", cu);
    }
}

