/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class ColumnTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";

    public ColumnTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column");
            }
        });
    }

    private ICompilationUnit createTestColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(table = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(" + booleanElement + " = true)");
            }
        });
    }

    private ICompilationUnit createTestColumnWithIntElement(final String intElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(" + intElement + " = 5)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getName());
        ColumnTests.assertNull((Object)column.getNullable());
        ColumnTests.assertNull((Object)column.getInsertable());
        ColumnTests.assertNull((Object)column.getUnique());
        ColumnTests.assertNull((Object)column.getUpdatable());
        ColumnTests.assertNull((Object)column.getTable());
        ColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getName());
        column.setName("Foo");
        ColumnTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@Column(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        ColumnTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("(name", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        ColumnTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@Column(table = \"Foo\")", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("table", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        ColumnTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@Column(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("columnDefinition", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("unique");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUnique());
        this.assertSourceContains("@Column(unique = false)", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("unique", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("nullable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        this.assertSourceContains("@Column(nullable = false)", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("nullable", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("insertable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        this.assertSourceContains("@Column(insertable = false)", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("insertable", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("updatable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        this.assertSourceContains("@Column(updatable = false)", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("updatable", cu);
    }

    public void testGetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("length");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)5, (Object)column.getLength());
    }

    public void testSetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getLength());
        column.setLength(Integer.valueOf(5));
        ColumnTests.assertEquals((Object)5, (Object)column.getLength());
        this.assertSourceContains("@Column(length = 5)", cu);
        column.setLength(null);
        this.assertSourceDoesNotContain("length", cu);
    }

    public void testGetPrecision() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("precision");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)5, (Object)column.getPrecision());
    }

    public void testSetPrecision() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertEquals(null, (Object)column.getPrecision());
        column.setPrecision(Integer.valueOf(5));
        ColumnTests.assertEquals((Object)5, (Object)column.getPrecision());
        this.assertSourceContains("@Column(precision = 5)", cu);
        column.setPrecision(null);
        this.assertSourceDoesNotContain("precision", cu);
    }

    public void testGetScale() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("scale");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)5, (Object)column.getScale());
    }

    public void testSetScale() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getScale());
        column.setScale(Integer.valueOf(5));
        ColumnTests.assertEquals((Object)5, (Object)column.getScale());
        this.assertSourceContains("@Column(scale = 5)", cu);
        column.setScale(null);
        this.assertSourceDoesNotContain("scale", cu);
    }
}

