/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;

public interface Table
extends JpaContextModel {
    public static final Transformer<Table, String> NAME_TRANSFORMER = new NameTransformer();
    public static final String SPECIFIED_NAME_PROPERTY = "specifiedName";
    public static final String DEFAULT_NAME_PROPERTY = "defaultName";
    public static final Transformer<Table, org.eclipse.jpt.jpa.db.Table> DB_TABLE_TRANSFORMER = new DbTableTransformer();
    public static final String SPECIFIED_SCHEMA_PROPERTY = "specifiedSchema";
    public static final String DEFAULT_SCHEMA_PROPERTY = "defaultSchema";
    public static final String SPECIFIED_CATALOG_PROPERTY = "specifiedCatalog";
    public static final String DEFAULT_CATALOG_PROPERTY = "defaultCatalog";
    public static final String UNIQUE_CONSTRAINTS_LIST = "uniqueConstraints";

    public String getName();

    public String getSpecifiedName();

    public String getDefaultName();

    public TextRange getNameValidationTextRange();

    public boolean isResolved();

    public org.eclipse.jpt.jpa.db.Table getDbTable();

    public String getSchema();

    public String getSpecifiedSchema();

    public String getDefaultSchema();

    public boolean schemaIsResolved();

    public Schema getDbSchema();

    public TextRange getSchemaValidationTextRange();

    public String getCatalog();

    public String getSpecifiedCatalog();

    public String getDefaultCatalog();

    public boolean catalogIsResolved();

    public Catalog getDbCatalog();

    public TextRange getCatalogValidationTextRange();

    public ListIterable<? extends UniqueConstraint> getUniqueConstraints();

    public int getUniqueConstraintsSize();

    public UniqueConstraint getUniqueConstraint(int var1);

    public SchemaContainer getDbSchemaContainer();

    public boolean validatesAgainstDatabase();

    public static class DbTableTransformer
    extends TransformerAdapter<Table, org.eclipse.jpt.jpa.db.Table> {
        public org.eclipse.jpt.jpa.db.Table transform(Table table) {
            return table.getDbTable();
        }
    }

    public static class NameTransformer
    extends TransformerAdapter<Table, String> {
        public String transform(Table table) {
            return table.getName();
        }
    }

    public static interface ParentAdapter<P extends JpaContextModel> {
        public P getTableParent();

        public JpaValidator buildTableValidator(Table var1);
    }
}

